/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.execution.CheckpointType;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.dispatcher.DispatcherOperationCaches;
import org.apache.flink.runtime.dispatcher.TriggerCheckpointFunction;
import org.apache.flink.runtime.dispatcher.TriggerSavepointFunction;
import org.apache.flink.runtime.dispatcher.TriggerSavepointMode;
import org.apache.flink.runtime.dispatcher.UnknownOperationKeyException;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.handler.async.CompletedOperationCache;
import org.apache.flink.runtime.rest.handler.async.OperationResult;
import org.apache.flink.runtime.rest.handler.job.AsynchronousJobOperationKey;
import org.apache.flink.util.concurrent.FutureUtils;

public class DispatcherCachedOperationsHandler {
    private final CompletedOperationCache<AsynchronousJobOperationKey, String> savepointTriggerCache;
    private final CompletedOperationCache<AsynchronousJobOperationKey, Long> checkpointTriggerCache;
    private final TriggerCheckpointFunction triggerCheckpointFunction;
    private final TriggerSavepointFunction triggerSavepointFunction;
    private final TriggerSavepointFunction stopWithSavepointFunction;

    DispatcherCachedOperationsHandler(DispatcherOperationCaches operationCaches, TriggerCheckpointFunction triggerCheckpointFunction, TriggerSavepointFunction triggerSavepointFunction, TriggerSavepointFunction stopWithSavepointFunction) {
        this(triggerCheckpointFunction, operationCaches.getCheckpointTriggerCache(), triggerSavepointFunction, stopWithSavepointFunction, operationCaches.getSavepointTriggerCache());
    }

    @VisibleForTesting
    DispatcherCachedOperationsHandler(TriggerCheckpointFunction triggerCheckpointFunction, CompletedOperationCache<AsynchronousJobOperationKey, Long> checkpointTriggerCache, TriggerSavepointFunction triggerSavepointFunction, TriggerSavepointFunction stopWithSavepointFunction, CompletedOperationCache<AsynchronousJobOperationKey, String> savepointTriggerCache) {
        this.triggerCheckpointFunction = triggerCheckpointFunction;
        this.checkpointTriggerCache = checkpointTriggerCache;
        this.triggerSavepointFunction = triggerSavepointFunction;
        this.stopWithSavepointFunction = stopWithSavepointFunction;
        this.savepointTriggerCache = savepointTriggerCache;
    }

    public CompletableFuture<Acknowledge> triggerCheckpoint(AsynchronousJobOperationKey operationKey, CheckpointType checkpointType, Duration timeout) {
        if (!this.checkpointTriggerCache.containsOperation(operationKey)) {
            this.checkpointTriggerCache.registerOngoingOperation(operationKey, this.triggerCheckpointFunction.apply(operationKey.getJobId(), checkpointType, timeout));
        }
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<OperationResult<Long>> getCheckpointStatus(AsynchronousJobOperationKey operationKey) {
        return this.checkpointTriggerCache.get(operationKey).map(CompletableFuture::completedFuture).orElse(FutureUtils.completedExceptionally((Throwable)((Object)new UnknownOperationKeyException(operationKey))));
    }

    public CompletableFuture<Acknowledge> triggerSavepoint(AsynchronousJobOperationKey operationKey, String targetDirectory, SavepointFormatType formatType, TriggerSavepointMode savepointMode, Duration timeout) {
        return this.registerOperationIdempotently(operationKey, () -> this.triggerSavepointFunction.apply(operationKey.getJobId(), targetDirectory, formatType, savepointMode, timeout));
    }

    public CompletableFuture<Acknowledge> stopWithSavepoint(AsynchronousJobOperationKey operationKey, String targetDirectory, SavepointFormatType formatType, TriggerSavepointMode savepointMode, Duration timeout) {
        return this.registerOperationIdempotently(operationKey, () -> this.stopWithSavepointFunction.apply(operationKey.getJobId(), targetDirectory, formatType, savepointMode, timeout));
    }

    public CompletableFuture<OperationResult<String>> getSavepointStatus(AsynchronousJobOperationKey operationKey) {
        return this.savepointTriggerCache.get(operationKey).map(CompletableFuture::completedFuture).orElse(FutureUtils.completedExceptionally((Throwable)((Object)new UnknownOperationKeyException(operationKey))));
    }

    private CompletableFuture<Acknowledge> registerOperationIdempotently(AsynchronousJobOperationKey operationKey, Supplier<CompletableFuture<String>> operation) {
        if (!this.savepointTriggerCache.containsOperation(operationKey)) {
            this.savepointTriggerCache.registerOngoingOperation(operationKey, operation.get());
        }
        return CompletableFuture.completedFuture(Acknowledge.get());
    }
}

