/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.io.network.api.writer.ChannelSelector;
import org.apache.flink.runtime.io.network.api.writer.SubtaskStateMapper;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public abstract class StreamPartitioner<T>
implements ChannelSelector<SerializationDelegate<StreamRecord<T>>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int numberOfChannels;
    private boolean supportsUnalignedCheckpoint = true;

    @Override
    public void setup(int numberOfChannels) {
        this.numberOfChannels = numberOfChannels;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    public abstract StreamPartitioner<T> copy();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamPartitioner that = (StreamPartitioner)o;
        return this.numberOfChannels == that.numberOfChannels;
    }

    public int hashCode() {
        return Objects.hash(this.numberOfChannels);
    }

    public SubtaskStateMapper getUpstreamSubtaskStateMapper() {
        return SubtaskStateMapper.ARBITRARY;
    }

    public abstract SubtaskStateMapper getDownstreamSubtaskStateMapper();

    public abstract boolean isPointwise();

    public boolean isSupportsUnalignedCheckpoint() {
        return this.supportsUnalignedCheckpoint && !this.isPointwise() && !this.isBroadcast();
    }

    public void disableUnalignedCheckpoints() {
        this.supportsUnalignedCheckpoint = false;
    }
}

