/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.state.InternalPriorityQueue;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupedInternalPriorityQueue;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.InternalTimersSnapshot;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.TimerHeapInternalTimer;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.StreamTaskCancellationContext;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.BiConsumerWithException;

public class InternalTimerServiceImpl<K, N>
implements InternalTimerService<N> {
    protected final ProcessingTimeService processingTimeService;
    protected final TaskIOMetricGroup taskIOMetricGroup;
    protected final KeyContext keyContext;
    protected final KeyGroupedInternalPriorityQueue<TimerHeapInternalTimer<K, N>> processingTimeTimersQueue;
    protected final KeyGroupedInternalPriorityQueue<TimerHeapInternalTimer<K, N>> eventTimeTimersQueue;
    protected final StreamTaskCancellationContext cancellationContext;
    private final KeyGroupRange localKeyGroupRange;
    private final int localKeyGroupRangeStartIdx;
    protected long currentWatermark = Long.MIN_VALUE;
    protected ScheduledFuture<?> nextTimer;
    private TypeSerializer<K> keySerializer;
    private TypeSerializer<N> namespaceSerializer;
    protected Triggerable<K, N> triggerTarget;
    private volatile boolean isInitialized;
    private TypeSerializer<K> keyDeserializer;
    private TypeSerializer<N> namespaceDeserializer;
    private InternalTimersSnapshot<K, N> restoredTimersSnapshot;

    InternalTimerServiceImpl(TaskIOMetricGroup taskIOMetricGroup, KeyGroupRange localKeyGroupRange, KeyContext keyContext, ProcessingTimeService processingTimeService, KeyGroupedInternalPriorityQueue<TimerHeapInternalTimer<K, N>> processingTimeTimersQueue, KeyGroupedInternalPriorityQueue<TimerHeapInternalTimer<K, N>> eventTimeTimersQueue, StreamTaskCancellationContext cancellationContext) {
        this.taskIOMetricGroup = taskIOMetricGroup;
        this.keyContext = (KeyContext)Preconditions.checkNotNull((Object)keyContext);
        this.processingTimeService = (ProcessingTimeService)Preconditions.checkNotNull((Object)processingTimeService);
        this.localKeyGroupRange = (KeyGroupRange)Preconditions.checkNotNull((Object)localKeyGroupRange);
        this.processingTimeTimersQueue = (KeyGroupedInternalPriorityQueue)Preconditions.checkNotNull(processingTimeTimersQueue);
        this.eventTimeTimersQueue = (KeyGroupedInternalPriorityQueue)Preconditions.checkNotNull(eventTimeTimersQueue);
        this.cancellationContext = cancellationContext;
        int startIdx = Integer.MAX_VALUE;
        for (Integer keyGroupIdx : localKeyGroupRange) {
            startIdx = Math.min(keyGroupIdx, startIdx);
        }
        this.localKeyGroupRangeStartIdx = startIdx;
    }

    public void startTimerService(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, Triggerable<K, N> triggerTarget) {
        if (!this.isInitialized) {
            if (keySerializer == null || namespaceSerializer == null) {
                throw new IllegalArgumentException("The TimersService serializers cannot be null.");
            }
            if (this.keySerializer != null || this.namespaceSerializer != null || this.triggerTarget != null) {
                throw new IllegalStateException("The TimerService has already been initialized.");
            }
            if (this.restoredTimersSnapshot != null) {
                TypeSerializerSchemaCompatibility keySerializerCompatibility = keySerializer.snapshotConfiguration().resolveSchemaCompatibility(this.restoredTimersSnapshot.getKeySerializerSnapshot());
                if (keySerializerCompatibility.isIncompatible() || keySerializerCompatibility.isCompatibleAfterMigration()) {
                    throw new IllegalStateException("Tried to initialize restored TimerService with new key serializer that requires migration or is incompatible.");
                }
                TypeSerializerSchemaCompatibility namespaceSerializerCompatibility = namespaceSerializer.snapshotConfiguration().resolveSchemaCompatibility(this.restoredTimersSnapshot.getNamespaceSerializerSnapshot());
                this.restoredTimersSnapshot = null;
                if (namespaceSerializerCompatibility.isIncompatible() || namespaceSerializerCompatibility.isCompatibleAfterMigration()) {
                    throw new IllegalStateException("Tried to initialize restored TimerService with new namespace serializer that requires migration or is incompatible.");
                }
                this.keySerializer = keySerializerCompatibility.isCompatibleAsIs() ? keySerializer : keySerializerCompatibility.getReconfiguredSerializer();
                this.namespaceSerializer = namespaceSerializerCompatibility.isCompatibleAsIs() ? namespaceSerializer : namespaceSerializerCompatibility.getReconfiguredSerializer();
            } else {
                this.keySerializer = keySerializer;
                this.namespaceSerializer = namespaceSerializer;
            }
            this.keyDeserializer = null;
            this.namespaceDeserializer = null;
            this.triggerTarget = (Triggerable)Preconditions.checkNotNull(triggerTarget);
            InternalTimer headTimer = (InternalTimer)this.processingTimeTimersQueue.peek();
            if (headTimer != null) {
                this.nextTimer = this.processingTimeService.registerTimer(headTimer.getTimestamp(), this::onProcessingTime);
            }
            this.isInitialized = true;
        } else if (!this.keySerializer.equals(keySerializer) || !this.namespaceSerializer.equals(namespaceSerializer)) {
            throw new IllegalArgumentException("Already initialized Timer Service tried to be initialized with different key and namespace serializers.");
        }
    }

    @Override
    public long currentProcessingTime() {
        return this.processingTimeService.getCurrentProcessingTime();
    }

    @Override
    public long currentWatermark() {
        return this.currentWatermark;
    }

    @Override
    public void initializeWatermark(long watermark) {
        this.currentWatermark = watermark;
    }

    @Override
    public void registerProcessingTimeTimer(N namespace, long time) {
        InternalTimer oldHead = (InternalTimer)this.processingTimeTimersQueue.peek();
        if (this.processingTimeTimersQueue.add(new TimerHeapInternalTimer<Object, N>(time, this.keyContext.getCurrentKey(), namespace))) {
            long nextTriggerTime;
            long l = nextTriggerTime = oldHead != null ? oldHead.getTimestamp() : Long.MAX_VALUE;
            if (time < nextTriggerTime) {
                if (this.nextTimer != null) {
                    this.nextTimer.cancel(false);
                }
                this.nextTimer = this.processingTimeService.registerTimer(time, this::onProcessingTime);
            }
        }
    }

    @Override
    public void registerEventTimeTimer(N namespace, long time) {
        this.eventTimeTimersQueue.add(new TimerHeapInternalTimer<Object, N>(time, this.keyContext.getCurrentKey(), namespace));
    }

    @Override
    public void deleteProcessingTimeTimer(N namespace, long time) {
        this.processingTimeTimersQueue.remove(new TimerHeapInternalTimer<Object, N>(time, this.keyContext.getCurrentKey(), namespace));
    }

    @Override
    public void deleteEventTimeTimer(N namespace, long time) {
        this.eventTimeTimersQueue.remove(new TimerHeapInternalTimer<Object, N>(time, this.keyContext.getCurrentKey(), namespace));
    }

    @Override
    public void forEachEventTimeTimer(BiConsumerWithException<N, Long, Exception> consumer) throws Exception {
        this.foreachTimer(consumer, this.eventTimeTimersQueue);
    }

    @Override
    public void forEachProcessingTimeTimer(BiConsumerWithException<N, Long, Exception> consumer) throws Exception {
        this.foreachTimer(consumer, this.processingTimeTimersQueue);
    }

    protected void foreachTimer(BiConsumerWithException<N, Long, Exception> consumer, KeyGroupedInternalPriorityQueue<TimerHeapInternalTimer<K, N>> queue) throws Exception {
        try (CloseableIterator iterator = queue.iterator();){
            while (iterator.hasNext()) {
                TimerHeapInternalTimer timer = (TimerHeapInternalTimer)iterator.next();
                this.keyContext.setCurrentKey(timer.getKey());
                consumer.accept(timer.getNamespace(), (Object)timer.getTimestamp());
            }
        }
    }

    void onProcessingTime(long time) throws Exception {
        InternalTimer timer;
        this.nextTimer = null;
        while ((timer = (InternalTimer)this.processingTimeTimersQueue.peek()) != null && timer.getTimestamp() <= time && !this.cancellationContext.isCancelled()) {
            this.keyContext.setCurrentKey(timer.getKey());
            this.processingTimeTimersQueue.poll();
            this.triggerTarget.onProcessingTime(timer);
            this.taskIOMetricGroup.getNumFiredTimers().inc();
        }
        if (timer != null && this.nextTimer == null) {
            this.nextTimer = this.processingTimeService.registerTimer(timer.getTimestamp(), this::onProcessingTime);
        }
    }

    public void advanceWatermark(long time) throws Exception {
        Preconditions.checkState((boolean)this.tryAdvanceWatermark(time, () -> false));
    }

    public boolean tryAdvanceWatermark(long time, InternalTimeServiceManager.ShouldStopAdvancingFn shouldStopAdvancingFn) throws Exception {
        InternalTimer timer;
        this.currentWatermark = time;
        boolean interrupted = false;
        while ((timer = (InternalTimer)this.eventTimeTimersQueue.peek()) != null && timer.getTimestamp() <= time && !this.cancellationContext.isCancelled() && !interrupted) {
            this.keyContext.setCurrentKey(timer.getKey());
            this.eventTimeTimersQueue.poll();
            this.triggerTarget.onEventTime(timer);
            this.taskIOMetricGroup.getNumFiredTimers().inc();
            interrupted = shouldStopAdvancingFn.test();
        }
        return !interrupted;
    }

    public InternalTimersSnapshot<K, N> snapshotTimersForKeyGroup(int keyGroupIdx) {
        return new InternalTimersSnapshot<K, N>(this.keySerializer, this.namespaceSerializer, this.eventTimeTimersQueue.getSubsetForKeyGroup(keyGroupIdx), this.processingTimeTimersQueue.getSubsetForKeyGroup(keyGroupIdx));
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public void restoreTimersForKeyGroup(InternalTimersSnapshot<?, ?> restoredSnapshot, int keyGroupIdx) {
        this.restoredTimersSnapshot = restoredSnapshot;
        TypeSerializer restoredKeySerializer = this.restoredTimersSnapshot.getKeySerializerSnapshot().restoreSerializer();
        if (this.keyDeserializer != null && !this.keyDeserializer.equals((Object)restoredKeySerializer)) {
            throw new IllegalArgumentException("Tried to restore timers for the same service with different key serializers.");
        }
        this.keyDeserializer = restoredKeySerializer;
        TypeSerializer restoredNamespaceSerializer = this.restoredTimersSnapshot.getNamespaceSerializerSnapshot().restoreSerializer();
        if (this.namespaceDeserializer != null && !this.namespaceDeserializer.equals((Object)restoredNamespaceSerializer)) {
            throw new IllegalArgumentException("Tried to restore timers for the same service with different namespace serializers.");
        }
        this.namespaceDeserializer = restoredNamespaceSerializer;
        Preconditions.checkArgument((boolean)this.localKeyGroupRange.contains(keyGroupIdx), (Object)("Key Group " + keyGroupIdx + " does not belong to the local range."));
        this.eventTimeTimersQueue.addAll(this.restoredTimersSnapshot.getEventTimeTimers());
        this.processingTimeTimersQueue.addAll(this.restoredTimersSnapshot.getProcessingTimeTimers());
    }

    @VisibleForTesting
    public int numProcessingTimeTimers() {
        return this.processingTimeTimersQueue.size();
    }

    @VisibleForTesting
    public int numEventTimeTimers() {
        return this.eventTimeTimersQueue.size();
    }

    @VisibleForTesting
    public int numProcessingTimeTimers(N namespace) {
        return this.countTimersInNamespaceInternal(namespace, this.processingTimeTimersQueue);
    }

    @VisibleForTesting
    public int numEventTimeTimers(N namespace) {
        return this.countTimersInNamespaceInternal(namespace, this.eventTimeTimersQueue);
    }

    private int countTimersInNamespaceInternal(N namespace, InternalPriorityQueue<TimerHeapInternalTimer<K, N>> queue) {
        int count = 0;
        try (CloseableIterator<TimerHeapInternalTimer<K, N>> iterator = queue.iterator();){
            while (iterator.hasNext()) {
                TimerHeapInternalTimer timer = (TimerHeapInternalTimer)iterator.next();
                if (!timer.getNamespace().equals(namespace)) continue;
                ++count;
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Exception when closing iterator.", (Throwable)e);
        }
        return count;
    }

    @VisibleForTesting
    int getLocalKeyGroupRangeStartIdx() {
        return this.localKeyGroupRangeStartIdx;
    }

    @VisibleForTesting
    List<Set<TimerHeapInternalTimer<K, N>>> getEventTimeTimersPerKeyGroup() {
        return this.partitionElementsByKeyGroup(this.eventTimeTimersQueue);
    }

    @VisibleForTesting
    List<Set<TimerHeapInternalTimer<K, N>>> getProcessingTimeTimersPerKeyGroup() {
        return this.partitionElementsByKeyGroup(this.processingTimeTimersQueue);
    }

    private <T> List<Set<T>> partitionElementsByKeyGroup(KeyGroupedInternalPriorityQueue<T> keyGroupedQueue) {
        ArrayList<Set<T>> result = new ArrayList<Set<T>>(this.localKeyGroupRange.getNumberOfKeyGroups());
        for (int keyGroup : this.localKeyGroupRange) {
            result.add(Collections.unmodifiableSet(keyGroupedQueue.getSubsetForKeyGroup(keyGroup)));
        }
        return result;
    }
}

