/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.execution.CheckpointType;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.dispatcher.TriggerSavepointMode;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobResourceRequirements;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.webmonitor.ClusterOverview;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.runtime.rest.handler.async.OperationResult;
import org.apache.flink.runtime.rest.handler.job.AsynchronousJobOperationKey;
import org.apache.flink.runtime.rest.messages.ThreadDumpInfo;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcTimeout;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.concurrent.FutureUtils;

public interface RestfulGateway
extends RpcGateway {
    public CompletableFuture<Acknowledge> cancelJob(JobID var1, @RpcTimeout Duration var2);

    default public CompletableFuture<ArchivedExecutionGraph> requestJob(JobID jobId, @RpcTimeout Duration timeout) {
        return this.requestExecutionGraphInfo(jobId, timeout).thenApply(ExecutionGraphInfo::getArchivedExecutionGraph);
    }

    public CompletableFuture<ExecutionGraphInfo> requestExecutionGraphInfo(JobID var1, @RpcTimeout Duration var2);

    public CompletableFuture<CheckpointStatsSnapshot> requestCheckpointStats(JobID var1, @RpcTimeout Duration var2);

    public CompletableFuture<JobResult> requestJobResult(JobID var1, @RpcTimeout Duration var2);

    public CompletableFuture<MultipleJobsDetails> requestMultipleJobDetails(@RpcTimeout Duration var1);

    public CompletableFuture<ClusterOverview> requestClusterOverview(@RpcTimeout Duration var1);

    public CompletableFuture<Collection<String>> requestMetricQueryServiceAddresses(@RpcTimeout Duration var1);

    public CompletableFuture<Collection<Tuple2<ResourceID, String>>> requestTaskManagerMetricQueryServiceAddresses(@RpcTimeout Duration var1);

    public CompletableFuture<ThreadDumpInfo> requestThreadDump(@RpcTimeout Duration var1);

    default public CompletableFuture<Acknowledge> triggerCheckpoint(AsynchronousJobOperationKey operationKey, CheckpointType checkpointType, @RpcTimeout Duration timeout) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<OperationResult<Long>> getTriggeredCheckpointStatus(AsynchronousJobOperationKey operationKey) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<Acknowledge> triggerSavepoint(AsynchronousJobOperationKey operationKey, String targetDirectory, SavepointFormatType formatType, TriggerSavepointMode savepointMode, @RpcTimeout Duration timeout) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<Acknowledge> stopWithSavepoint(AsynchronousJobOperationKey operationKey, String targetDirectory, SavepointFormatType formatType, TriggerSavepointMode savepointMode, @RpcTimeout Duration timeout) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<OperationResult<String>> getTriggeredSavepointStatus(AsynchronousJobOperationKey operationKey) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<Acknowledge> disposeSavepoint(String savepointPath, @RpcTimeout Duration timeout) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<JobStatus> requestJobStatus(JobID jobId, @RpcTimeout Duration timeout) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<Acknowledge> shutDownCluster() {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CoordinationResponse> deliverCoordinationRequestToCoordinator(JobID jobId, String operatorUid, SerializedValue<CoordinationRequest> serializedRequest, @RpcTimeout Duration timeout) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<Void> reportJobClientHeartbeat(JobID jobId, long expiredTimestamp, Duration timeout) {
        return FutureUtils.completedVoidFuture();
    }

    default public CompletableFuture<JobResourceRequirements> requestJobResourceRequirements(JobID jobId) {
        throw new UnsupportedOperationException("Operation is not yet implemented.");
    }

    default public CompletableFuture<Acknowledge> updateJobResourceRequirements(JobID jobId, JobResourceRequirements jobResourceRequirements) {
        throw new UnsupportedOperationException("Operation is not yet implemented.");
    }
}

