/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.RegisteredBroadcastStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredOperatorStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredPriorityQueueStateBackendMetaInfo;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.v2.RegisteredKeyValueStateBackendMetaInfo;

public abstract class RegisteredStateMetaInfoBase {
    @Nonnull
    protected final String name;

    public RegisteredStateMetaInfoBase(@Nonnull String name) {
        this.name = name;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public abstract StateMetaInfoSnapshot snapshot();

    @Nonnull
    public abstract RegisteredStateMetaInfoBase withSerializerUpgradesAllowed();

    public static RegisteredStateMetaInfoBase fromMetaInfoSnapshot(@Nonnull StateMetaInfoSnapshot snapshot) {
        StateMetaInfoSnapshot.BackendStateType backendStateType = snapshot.getBackendStateType();
        switch (backendStateType) {
            case KEY_VALUE: {
                return new org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo(snapshot);
            }
            case OPERATOR: {
                return new RegisteredOperatorStateBackendMetaInfo(snapshot);
            }
            case BROADCAST: {
                return new RegisteredBroadcastStateBackendMetaInfo(snapshot);
            }
            case PRIORITY_QUEUE: {
                return new RegisteredPriorityQueueStateBackendMetaInfo(snapshot);
            }
            case KEY_VALUE_V2: {
                return new RegisteredKeyValueStateBackendMetaInfo(snapshot);
            }
        }
        throw new IllegalArgumentException("Unknown backend state type: " + backendStateType);
    }

    public final Key asMapKey() {
        return new Key(this);
    }

    public static final class Key {
        private final RegisteredStateMetaInfoBase registeredStateMetaInfoBase;

        private Key(RegisteredStateMetaInfoBase metaInfoBase) {
            this.registeredStateMetaInfoBase = metaInfoBase;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            return Objects.equals(this.registeredStateMetaInfoBase.getName(), that.registeredStateMetaInfoBase.getName()) && Objects.equals(this.registeredStateMetaInfoBase.getClass(), that.registeredStateMetaInfoBase.getClass());
        }

        public int hashCode() {
            return Objects.hash(this.registeredStateMetaInfoBase.getName(), this.registeredStateMetaInfoBase.getClass());
        }

        public RegisteredStateMetaInfoBase getRegisteredStateMetaInfoBase() {
            return this.registeredStateMetaInfoBase;
        }
    }
}

