/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractAccessExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.JobPlanInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.OnlyExecutionGraphJsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobPlanHandler
extends AbstractAccessExecutionGraphHandler<JobPlanInfo, JobMessageParameters>
implements OnlyExecutionGraphJsonArchivist {
    public JobPlanHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> headers, MessageHeaders<EmptyRequestBody, JobPlanInfo, JobMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(leaderRetriever, timeout, headers, messageHeaders, executionGraphCache, executor);
    }

    @Override
    protected JobPlanInfo handleRequest(HandlerRequest<EmptyRequestBody> request, AccessExecutionGraph executionGraph) throws RestHandlerException {
        return JobPlanHandler.createJobPlanInfo(executionGraph);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        JobPlanInfo json = JobPlanHandler.createJobPlanInfo(graph);
        String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString());
        return Collections.singleton(new ArchivedJson(path, json));
    }

    private static JobPlanInfo createJobPlanInfo(AccessExecutionGraph executionGraph) {
        return new JobPlanInfo(executionGraph.getJsonPlan());
    }
}

