/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.math.RoundingMode;
import java.time.Duration;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.configuration.RpcOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;

public class SlotManagerConfiguration {
    private final Duration taskManagerRequestTimeout;
    private final Duration taskManagerTimeout;
    private final Duration requirementCheckDelay;
    private final Duration declareNeededResourceDelay;
    private final TaskManagerOptions.TaskManagerLoadBalanceMode taskManagerLoadBalanceMode;
    private final WorkerResourceSpec defaultWorkerResourceSpec;
    private final int numSlotsPerWorker;
    private final int minSlotNum;
    private final int maxSlotNum;
    private final CPUResource minTotalCpu;
    private final CPUResource maxTotalCpu;
    private final MemorySize minTotalMem;
    private final MemorySize maxTotalMem;
    private final int redundantTaskManagerNum;

    public SlotManagerConfiguration(Duration taskManagerRequestTimeout, Duration taskManagerTimeout, Duration requirementCheckDelay, Duration declareNeededResourceDelay, TaskManagerOptions.TaskManagerLoadBalanceMode taskManagerLoadBalanceMode, WorkerResourceSpec defaultWorkerResourceSpec, int numSlotsPerWorker, int minSlotNum, int maxSlotNum, CPUResource minTotalCpu, CPUResource maxTotalCpu, MemorySize minTotalMem, MemorySize maxTotalMem, int redundantTaskManagerNum) {
        this.taskManagerRequestTimeout = (Duration)Preconditions.checkNotNull((Object)taskManagerRequestTimeout);
        this.taskManagerTimeout = (Duration)Preconditions.checkNotNull((Object)taskManagerTimeout);
        this.requirementCheckDelay = (Duration)Preconditions.checkNotNull((Object)requirementCheckDelay);
        this.declareNeededResourceDelay = (Duration)Preconditions.checkNotNull((Object)declareNeededResourceDelay);
        this.taskManagerLoadBalanceMode = taskManagerLoadBalanceMode;
        this.defaultWorkerResourceSpec = (WorkerResourceSpec)Preconditions.checkNotNull((Object)defaultWorkerResourceSpec);
        Preconditions.checkState((numSlotsPerWorker > 0 ? 1 : 0) != 0);
        this.numSlotsPerWorker = numSlotsPerWorker;
        this.checkSlotNumResource(minSlotNum, maxSlotNum, defaultWorkerResourceSpec);
        this.checkTotalCPUResource(minTotalCpu, maxTotalCpu, defaultWorkerResourceSpec);
        this.checkTotalMemoryResource(minTotalMem, maxTotalMem, defaultWorkerResourceSpec);
        this.minSlotNum = minSlotNum;
        this.maxSlotNum = maxSlotNum;
        this.minTotalCpu = minTotalCpu;
        this.maxTotalCpu = maxTotalCpu;
        this.minTotalMem = minTotalMem;
        this.maxTotalMem = maxTotalMem;
        Preconditions.checkState((redundantTaskManagerNum >= 0 ? 1 : 0) != 0);
        this.redundantTaskManagerNum = redundantTaskManagerNum;
    }

    private void checkSlotNumResource(int minSlotNum, int maxSlotNum, WorkerResourceSpec workerResourceSpec) {
        int maxSlotWorkerNum;
        Preconditions.checkState((minSlotNum >= 0 && minSlotNum <= maxSlotNum ? 1 : 0) != 0);
        Preconditions.checkState((maxSlotNum > 0 ? 1 : 0) != 0);
        if (minSlotNum == 0) {
            return;
        }
        int minSlotWorkerNum = (int)Math.ceil((double)minSlotNum / (double)workerResourceSpec.getNumSlots());
        Preconditions.checkState((minSlotWorkerNum <= (maxSlotWorkerNum = (int)Math.floor((double)maxSlotNum / (double)workerResourceSpec.getNumSlots())) ? 1 : 0) != 0);
    }

    private void checkTotalCPUResource(CPUResource minTotalCpu, CPUResource maxTotalCpu, WorkerResourceSpec workerResourceSpec) {
        int maxCPUWorkerNum;
        Preconditions.checkNotNull((Object)minTotalCpu);
        Preconditions.checkNotNull((Object)maxTotalCpu);
        Preconditions.checkState((maxTotalCpu.compareTo((Resource)minTotalCpu) >= 0 ? 1 : 0) != 0);
        if (minTotalCpu.isZero()) {
            return;
        }
        int minCPUWorkerNum = (int)minTotalCpu.getValue().divide(workerResourceSpec.getCpuCores().getValue(), 0, RoundingMode.CEILING).doubleValue();
        Preconditions.checkState((minCPUWorkerNum <= (maxCPUWorkerNum = (int)maxTotalCpu.getValue().divide(workerResourceSpec.getCpuCores().getValue(), 0, RoundingMode.FLOOR).doubleValue()) ? 1 : 0) != 0);
    }

    private void checkTotalMemoryResource(MemorySize minTotalMem, MemorySize maxTotalMem, WorkerResourceSpec workerResourceSpec) {
        int maxMemoryWorkerNum;
        Preconditions.checkNotNull((Object)minTotalMem);
        Preconditions.checkNotNull((Object)maxTotalMem);
        Preconditions.checkState((maxTotalMem.compareTo(minTotalMem) >= 0 ? 1 : 0) != 0);
        if (minTotalMem.compareTo(MemorySize.ZERO) == 0) {
            return;
        }
        int minMemoryWorkerNum = (int)Math.ceil((double)minTotalMem.getBytes() / (double)workerResourceSpec.getTotalMemSize().getBytes());
        Preconditions.checkState((minMemoryWorkerNum <= (maxMemoryWorkerNum = (int)Math.floor((double)maxTotalMem.getBytes() / (double)workerResourceSpec.getTotalMemSize().getBytes())) ? 1 : 0) != 0);
    }

    public Duration getTaskManagerRequestTimeout() {
        return this.taskManagerRequestTimeout;
    }

    public Duration getTaskManagerTimeout() {
        return this.taskManagerTimeout;
    }

    public Duration getRequirementCheckDelay() {
        return this.requirementCheckDelay;
    }

    public Duration getDeclareNeededResourceDelay() {
        return this.declareNeededResourceDelay;
    }

    public TaskManagerOptions.TaskManagerLoadBalanceMode getTaskManagerLoadBalanceMode() {
        return this.taskManagerLoadBalanceMode;
    }

    public WorkerResourceSpec getDefaultWorkerResourceSpec() {
        return this.defaultWorkerResourceSpec;
    }

    public int getNumSlotsPerWorker() {
        return this.numSlotsPerWorker;
    }

    public int getMinSlotNum() {
        return this.minSlotNum;
    }

    public int getMaxSlotNum() {
        return this.maxSlotNum;
    }

    public CPUResource getMinTotalCpu() {
        return this.minTotalCpu;
    }

    public CPUResource getMaxTotalCpu() {
        return this.maxTotalCpu;
    }

    public MemorySize getMinTotalMem() {
        return this.minTotalMem;
    }

    public MemorySize getMaxTotalMem() {
        return this.maxTotalMem;
    }

    public int getRedundantTaskManagerNum() {
        return this.redundantTaskManagerNum;
    }

    public static SlotManagerConfiguration fromConfiguration(Configuration configuration, WorkerResourceSpec defaultWorkerResourceSpec) throws ConfigurationException {
        Duration rpcTimeout = (Duration)configuration.get(RpcOptions.ASK_TIMEOUT_DURATION);
        Duration taskManagerTimeout = (Duration)configuration.get(ResourceManagerOptions.TASK_MANAGER_TIMEOUT);
        Duration requirementCheckDelay = (Duration)configuration.get(ResourceManagerOptions.REQUIREMENTS_CHECK_DELAY);
        Duration declareNeededResourceDelay = (Duration)configuration.get(ResourceManagerOptions.DECLARE_NEEDED_RESOURCE_DELAY);
        TaskManagerOptions.TaskManagerLoadBalanceMode taskManagerLoadBalanceMode = (TaskManagerOptions.TaskManagerLoadBalanceMode)configuration.get(TaskManagerOptions.TASK_MANAGER_LOAD_BALANCE_MODE);
        int numSlotsPerWorker = (Integer)configuration.get(TaskManagerOptions.NUM_TASK_SLOTS);
        int minSlotNum = (Integer)configuration.get(ResourceManagerOptions.MIN_SLOT_NUM);
        int maxSlotNum = (Integer)configuration.get(ResourceManagerOptions.MAX_SLOT_NUM);
        int redundantTaskManagerNum = (Integer)configuration.get(ResourceManagerOptions.REDUNDANT_TASK_MANAGER_NUM);
        return new SlotManagerConfiguration(rpcTimeout, taskManagerTimeout, requirementCheckDelay, declareNeededResourceDelay, taskManagerLoadBalanceMode, defaultWorkerResourceSpec, numSlotsPerWorker, minSlotNum, maxSlotNum, SlotManagerConfiguration.getMinTotalCpu(configuration, defaultWorkerResourceSpec, minSlotNum), SlotManagerConfiguration.getMaxTotalCpu(configuration, defaultWorkerResourceSpec, maxSlotNum), SlotManagerConfiguration.getMinTotalMem(configuration, defaultWorkerResourceSpec, minSlotNum), SlotManagerConfiguration.getMaxTotalMem(configuration, defaultWorkerResourceSpec, maxSlotNum), redundantTaskManagerNum);
    }

    private static CPUResource getMinTotalCpu(Configuration configuration, WorkerResourceSpec defaultWorkerResourceSpec, int minSlotNum) {
        return configuration.getOptional(ResourceManagerOptions.MIN_TOTAL_CPU).map(CPUResource::new).orElseGet(() -> minSlotNum == 0 ? new CPUResource(Double.MIN_VALUE) : (CPUResource)((CPUResource)defaultWorkerResourceSpec.getCpuCores().multiply(minSlotNum)).divide(defaultWorkerResourceSpec.getNumSlots()));
    }

    private static CPUResource getMaxTotalCpu(Configuration configuration, WorkerResourceSpec defaultWorkerResourceSpec, int maxSlotNum) {
        return configuration.getOptional(ResourceManagerOptions.MAX_TOTAL_CPU).map(CPUResource::new).orElseGet(() -> maxSlotNum == Integer.MAX_VALUE ? new CPUResource(Double.MAX_VALUE) : (CPUResource)((CPUResource)defaultWorkerResourceSpec.getCpuCores().multiply(maxSlotNum)).divide(defaultWorkerResourceSpec.getNumSlots()));
    }

    private static MemorySize getMinTotalMem(Configuration configuration, WorkerResourceSpec defaultWorkerResourceSpec, int minSlotNum) {
        return configuration.getOptional(ResourceManagerOptions.MIN_TOTAL_MEM).orElseGet(() -> minSlotNum == 0 ? MemorySize.ZERO : defaultWorkerResourceSpec.getTotalMemSize().multiply((double)minSlotNum).divide((long)defaultWorkerResourceSpec.getNumSlots()));
    }

    private static MemorySize getMaxTotalMem(Configuration configuration, WorkerResourceSpec defaultWorkerResourceSpec, int maxSlotNum) {
        return configuration.getOptional(ResourceManagerOptions.MAX_TOTAL_MEM).orElseGet(() -> maxSlotNum == Integer.MAX_VALUE ? MemorySize.MAX_VALUE : defaultWorkerResourceSpec.getTotalMemSize().multiply((double)maxSlotNum).divide((long)defaultWorkerResourceSpec.getNumSlots()));
    }
}

