/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;

final class PendingRequest {
    private final SlotRequestId slotRequestId;
    private final ResourceProfile resourceProfile;
    private final HashSet<AllocationID> preferredAllocations;
    private final CompletableFuture<PhysicalSlot> slotFuture;
    private final boolean isBatchRequest;
    private long unfulfillableSince;

    private PendingRequest(SlotRequestId slotRequestId, ResourceProfile resourceProfile, Collection<AllocationID> preferredAllocations, boolean isBatchRequest) {
        this.slotRequestId = slotRequestId;
        this.resourceProfile = resourceProfile;
        this.preferredAllocations = new HashSet<AllocationID>(preferredAllocations);
        this.isBatchRequest = isBatchRequest;
        this.slotFuture = new CompletableFuture();
        this.unfulfillableSince = Long.MAX_VALUE;
    }

    static PendingRequest createBatchRequest(SlotRequestId slotRequestId, ResourceProfile resourceProfile, Collection<AllocationID> preferredAllocations) {
        return new PendingRequest(slotRequestId, resourceProfile, preferredAllocations, true);
    }

    static PendingRequest createNormalRequest(SlotRequestId slotRequestId, ResourceProfile resourceProfile, Collection<AllocationID> preferredAllocations) {
        return new PendingRequest(slotRequestId, resourceProfile, preferredAllocations, false);
    }

    SlotRequestId getSlotRequestId() {
        return this.slotRequestId;
    }

    ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    Set<AllocationID> getPreferredAllocations() {
        return this.preferredAllocations;
    }

    CompletableFuture<PhysicalSlot> getSlotFuture() {
        return this.slotFuture;
    }

    void failRequest(Exception cause) {
        this.slotFuture.completeExceptionally(cause);
    }

    boolean isBatchRequest() {
        return this.isBatchRequest;
    }

    void markFulfillable() {
        this.unfulfillableSince = Long.MAX_VALUE;
    }

    void markUnfulfillable(long currentTimestamp) {
        if (this.isFulfillable()) {
            this.unfulfillableSince = currentTimestamp;
        }
    }

    private boolean isFulfillable() {
        return this.unfulfillableSince == Long.MAX_VALUE;
    }

    long getUnfulfillableSince() {
        return this.unfulfillableSince;
    }

    boolean fulfill(PhysicalSlot slot) {
        return this.slotFuture.complete(slot);
    }

    public String toString() {
        return "PendingRequest{slotRequestId=" + this.slotRequestId + ", resourceProfile=" + this.resourceProfile + ", preferredAllocations=" + this.preferredAllocations + ", isBatchRequest=" + this.isBatchRequest + ", unfulfillableSince=" + this.unfulfillableSince + "}";
    }
}

