/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ExecutionPlanUtils {

    private static final Logger LOG = LoggerFactory.getLogger(ExecutionPlanUtils.class);

    public static Map<String, DistributedCache.DistributedCacheEntry> prepareUserArtifactEntries(Map<String, DistributedCache.DistributedCacheEntry> userArtifacts, JobID jobId) {
        HashMap<String, DistributedCache.DistributedCacheEntry> result = new HashMap<String, DistributedCache.DistributedCacheEntry>();
        if (userArtifacts != null && !userArtifacts.isEmpty()) {
            try {
                java.nio.file.Path tmpDir = Files.createTempDirectory("flink-distributed-cache-" + jobId, new FileAttribute[0]);
                for (Map.Entry<String, DistributedCache.DistributedCacheEntry> originalEntry : userArtifacts.entrySet()) {
                    DistributedCache.DistributedCacheEntry entry;
                    Path filePath = new Path(originalEntry.getValue().filePath);
                    boolean isLocalDir = false;
                    try {
                        FileSystem sourceFs = filePath.getFileSystem();
                        isLocalDir = !sourceFs.isDistributedFS() && sourceFs.getFileStatus(filePath).isDir();
                    }
                    catch (IOException ioe) {
                        LOG.warn("Could not determine whether {} denotes a local path.", (Object)filePath, (Object)ioe);
                    }
                    if (isLocalDir) {
                        Path zip = FileUtils.compressDirectory((Path)filePath, (Path)new Path(tmpDir.toString(), filePath.getName() + ".zip"));
                        entry = new DistributedCache.DistributedCacheEntry(zip.toString(), originalEntry.getValue().isExecutable.booleanValue(), true);
                    } else {
                        entry = new DistributedCache.DistributedCacheEntry(filePath.toString(), originalEntry.getValue().isExecutable.booleanValue(), false);
                    }
                    result.put(originalEntry.getKey(), entry);
                }
            }
            catch (IOException ioe) {
                throw new FlinkRuntimeException("Could not compress distributed-cache artifacts.", (Throwable)ioe);
            }
        }
        return result;
    }
}

