/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.Serializable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.util.Preconditions;

public final class ResultPartitionID
implements Serializable {
    private static final long serialVersionUID = -902516386203787826L;
    private final IntermediateResultPartitionID partitionId;
    private final ExecutionAttemptID producerId;

    @VisibleForTesting
    public ResultPartitionID() {
        this(new IntermediateResultPartitionID(), ExecutionAttemptID.randomId());
    }

    public ResultPartitionID(IntermediateResultPartitionID partitionId, ExecutionAttemptID producerId) {
        this.partitionId = (IntermediateResultPartitionID)Preconditions.checkNotNull((Object)partitionId);
        this.producerId = (ExecutionAttemptID)Preconditions.checkNotNull((Object)producerId);
    }

    public ResultPartitionID(byte[] bytes) {
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeBytes(bytes);
        this.partitionId = IntermediateResultPartitionID.fromByteBuf(byteBuf);
        this.producerId = ExecutionAttemptID.fromByteBuf(byteBuf);
        byteBuf.release();
    }

    public IntermediateResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    public ExecutionAttemptID getProducerId() {
        return this.producerId;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == ResultPartitionID.class) {
            ResultPartitionID o = (ResultPartitionID)obj;
            return o.getPartitionId().equals(this.partitionId) && o.getProducerId().equals(this.producerId);
        }
        return false;
    }

    public int hashCode() {
        return this.partitionId.hashCode() ^ this.producerId.hashCode();
    }

    public String toString() {
        return this.partitionId.toString() + "@" + this.producerId.toString();
    }

    public byte[] getBytes() {
        ByteBuf byteBuf = Unpooled.buffer();
        this.partitionId.writeTo(byteBuf);
        this.producerId.writeTo(byteBuf);
        byte[] bytes = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(bytes);
        byteBuf.release();
        return bytes;
    }
}

