/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.util.function.BiConsumerWithException;

@Internal
public class TestInternalTimerService<K, N>
implements InternalTimerService<N> {
    private long currentProcessingTime = Long.MIN_VALUE;
    private long currentWatermark = Long.MIN_VALUE;
    private final KeyContext keyContext;
    private final PriorityQueue<Timer<K, N>> processingTimeTimersQueue;
    private final Set<Timer<K, N>> processingTimeTimers;
    private final Set<Timer<K, N>> watermarkTimers;
    private final PriorityQueue<Timer<K, N>> watermarkTimersQueue;

    public TestInternalTimerService(KeyContext keyContext) {
        this.keyContext = keyContext;
        this.watermarkTimers = new HashSet<Timer<K, N>>();
        this.watermarkTimersQueue = new PriorityQueue(100);
        this.processingTimeTimers = new HashSet<Timer<K, N>>();
        this.processingTimeTimersQueue = new PriorityQueue(100);
    }

    public long currentProcessingTime() {
        return this.currentProcessingTime;
    }

    public long currentWatermark() {
        return this.currentWatermark;
    }

    public void initializeWatermark(long watermark) {
        this.currentWatermark = watermark;
    }

    public void registerProcessingTimeTimer(N namespace, long time) {
        Timer<Object, N> timer = new Timer<Object, N>(time, this.keyContext.getCurrentKey(), namespace);
        if (this.processingTimeTimers.add(timer)) {
            this.processingTimeTimersQueue.add(timer);
        }
    }

    public void registerEventTimeTimer(N namespace, long time) {
        Timer<Object, N> timer = new Timer<Object, N>(time, this.keyContext.getCurrentKey(), namespace);
        if (this.watermarkTimers.add(timer)) {
            this.watermarkTimersQueue.add(timer);
        }
    }

    public void deleteProcessingTimeTimer(N namespace, long time) {
        Timer<Object, N> timer = new Timer<Object, N>(time, this.keyContext.getCurrentKey(), namespace);
        if (this.processingTimeTimers.remove(timer)) {
            this.processingTimeTimersQueue.remove(timer);
        }
    }

    public void deleteEventTimeTimer(N namespace, long time) {
        Timer<Object, N> timer = new Timer<Object, N>(time, this.keyContext.getCurrentKey(), namespace);
        if (this.watermarkTimers.remove(timer)) {
            this.watermarkTimersQueue.remove(timer);
        }
    }

    public void forEachEventTimeTimer(BiConsumerWithException<N, Long, Exception> consumer) throws Exception {
        for (Timer<K, N> timer : this.watermarkTimers) {
            this.keyContext.setCurrentKey(timer.getKey());
            consumer.accept(timer.getNamespace(), (Object)timer.getTimestamp());
        }
    }

    public void forEachProcessingTimeTimer(BiConsumerWithException<N, Long, Exception> consumer) throws Exception {
        for (Timer<K, N> timer : this.processingTimeTimers) {
            this.keyContext.setCurrentKey(timer.getKey());
            consumer.accept(timer.getNamespace(), (Object)timer.getTimestamp());
        }
    }

    public Collection<Timer<K, N>> advanceProcessingTime(long time) throws Exception {
        ArrayList<Timer<K, N>> result = new ArrayList<Timer<K, N>>();
        Timer<K, N> timer = this.processingTimeTimersQueue.peek();
        while (timer != null && timer.timestamp <= time) {
            this.processingTimeTimers.remove(timer);
            this.processingTimeTimersQueue.remove();
            result.add(timer);
            timer = this.processingTimeTimersQueue.peek();
        }
        this.currentProcessingTime = time;
        return result;
    }

    public Collection<Timer<K, N>> advanceWatermark(long time) throws Exception {
        ArrayList<Timer<K, N>> result = new ArrayList<Timer<K, N>>();
        Timer<K, N> timer = this.watermarkTimersQueue.peek();
        while (timer != null && timer.timestamp <= time) {
            this.watermarkTimers.remove(timer);
            this.watermarkTimersQueue.remove();
            result.add(timer);
            timer = this.watermarkTimersQueue.peek();
        }
        this.currentWatermark = time;
        return result;
    }

    public int numProcessingTimeTimers() {
        return this.processingTimeTimers.size();
    }

    public int numEventTimeTimers() {
        return this.watermarkTimers.size();
    }

    public int numProcessingTimeTimers(N namespace) {
        int count = 0;
        for (Timer<K, N> timer : this.processingTimeTimers) {
            if (!timer.getNamespace().equals(namespace)) continue;
            ++count;
        }
        return count;
    }

    public int numEventTimeTimers(N namespace) {
        int count = 0;
        for (Timer<K, N> timer : this.watermarkTimers) {
            if (!timer.getNamespace().equals(namespace)) continue;
            ++count;
        }
        return count;
    }

    public static class Timer<K, N>
    implements Comparable<Timer<K, N>> {
        private final long timestamp;
        private final K key;
        private final N namespace;

        public Timer(long timestamp, K key, N namespace) {
            this.timestamp = timestamp;
            this.key = key;
            this.namespace = namespace;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public K getKey() {
            return this.key;
        }

        public N getNamespace() {
            return this.namespace;
        }

        @Override
        public int compareTo(Timer<K, N> o) {
            return Long.compare(this.timestamp, o.timestamp);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Timer timer = (Timer)o;
            return this.timestamp == timer.timestamp && this.key.equals(timer.key) && this.namespace.equals(timer.namespace);
        }

        public int hashCode() {
            int result = (int)(this.timestamp ^ this.timestamp >>> 32);
            result = 31 * result + this.key.hashCode();
            result = 31 * result + this.namespace.hashCode();
            return result;
        }

        public String toString() {
            return "Timer{timestamp=" + this.timestamp + ", key=" + this.key + ", namespace=" + this.namespace + "}";
        }
    }
}

