/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.ttl.TtlMapState;
import org.apache.flink.runtime.state.ttl.TtlMapStateTestContext;
import org.apache.flink.shaded.guava32.com.google.common.collect.Sets;

class TtlMapStateAllEntriesTestContext
extends TtlMapStateTestContext<Map<Integer, String>, Set<Map.Entry<Integer, String>>> {
    TtlMapStateAllEntriesTestContext() {
    }

    @Override
    void initTestValues() {
        this.emptyValue = Collections.emptySet();
        this.updateEmpty = TtlMapStateAllEntriesTestContext.mapOf(Tuple2.of((Object)3, (Object)"3"), Tuple2.of((Object)5, (Object)"5"), Tuple2.of((Object)23, null), Tuple2.of((Object)10, (Object)"10"));
        this.updateUnexpired = TtlMapStateAllEntriesTestContext.mapOf(Tuple2.of((Object)12, (Object)"12"), Tuple2.of((Object)24, null), Tuple2.of((Object)7, (Object)"7"));
        this.updateExpired = TtlMapStateAllEntriesTestContext.mapOf(Tuple2.of((Object)15, (Object)"15"), Tuple2.of((Object)25, null), Tuple2.of((Object)4, (Object)"4"));
        this.getUpdateEmpty = ((Map)this.updateEmpty).entrySet();
        this.getUnexpired = ((Map)this.updateUnexpired).entrySet();
        this.getUpdateExpired = ((Map)this.updateExpired).entrySet();
    }

    @SafeVarargs
    private static <UK, UV> Map<UK, UV> mapOf(Tuple2<UK, UV> ... entries) {
        HashMap map = new HashMap();
        Arrays.stream(entries).forEach(t -> map.put(t.f0, t.f1));
        return map;
    }

    @Override
    public void update(Map<Integer, String> map) throws Exception {
        ((TtlMapState)this.ttlState).putAll(map);
    }

    @Override
    public Set<Map.Entry<Integer, String>> get() throws Exception {
        return StreamSupport.stream(((TtlMapState)this.ttlState).entries().spliterator(), false).collect(Collectors.toSet());
    }

    @Override
    public Object getOriginal() throws Exception {
        return ((InternalMapState)((TtlMapState)this.ttlState).original).entries() == null ? Collections.emptySet() : ((InternalMapState)((TtlMapState)this.ttlState).original).entries();
    }

    @Override
    public boolean isOriginalEmptyValue() throws Exception {
        return Objects.equals(this.emptyValue, Sets.newHashSet(((Iterable)this.getOriginal()).iterator()));
    }
}

