/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.token;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.security.token.DelegationTokenReceiverRepository;
import org.apache.flink.runtime.security.token.ExceptionThrowingDelegationTokenReceiver;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DelegationTokenReceiverRepositoryTest {
    DelegationTokenReceiverRepositoryTest() {
    }

    @BeforeEach
    public void beforeEach() {
        ExceptionThrowingDelegationTokenReceiver.reset();
    }

    @AfterEach
    public void afterEach() {
        ExceptionThrowingDelegationTokenReceiver.reset();
    }

    @Test
    public void configurationIsNullMustFailFast() {
        Assertions.assertThrows(Exception.class, () -> new DelegationTokenReceiverRepository(null, null));
    }

    @Test
    public void oneReceiverThrowsExceptionMustFailFast() {
        Assertions.assertThrows(Exception.class, () -> {
            ExceptionThrowingDelegationTokenReceiver.throwInInit.set(true);
            new DelegationTokenReceiverRepository(new Configuration(), null);
        });
    }

    @Test
    public void testAllReceiversLoaded() {
        Configuration configuration = new Configuration();
        configuration.set(ConfigurationUtils.getBooleanConfigOption((String)"security.delegation.token.provider.throw.enabled"), (Object)false);
        DelegationTokenReceiverRepository delegationTokenReceiverRepository = new DelegationTokenReceiverRepository(configuration, null);
        Assertions.assertEquals((int)3, (int)delegationTokenReceiverRepository.delegationTokenReceivers.size());
        Assertions.assertTrue((boolean)delegationTokenReceiverRepository.isReceiverLoaded("hadoopfs"));
        Assertions.assertTrue((boolean)delegationTokenReceiverRepository.isReceiverLoaded("hbase"));
        Assertions.assertTrue((boolean)delegationTokenReceiverRepository.isReceiverLoaded("test"));
        Assertions.assertTrue((boolean)ExceptionThrowingDelegationTokenReceiver.constructed.get());
        Assertions.assertFalse((boolean)delegationTokenReceiverRepository.isReceiverLoaded("throw"));
    }

    @Test
    public void testDelegationTokenDisabled() {
        Configuration configuration = new Configuration();
        configuration.set(SecurityOptions.DELEGATION_TOKENS_ENABLED, (Object)false);
        DelegationTokenReceiverRepository delegationTokenReceiverRepository = new DelegationTokenReceiverRepository(configuration, null);
        Assertions.assertEquals((int)0, (int)delegationTokenReceiverRepository.delegationTokenReceivers.size());
        Assertions.assertFalse((boolean)delegationTokenReceiverRepository.isReceiverLoaded("hadoopfs"));
        Assertions.assertFalse((boolean)delegationTokenReceiverRepository.isReceiverLoaded("hbase"));
        Assertions.assertFalse((boolean)delegationTokenReceiverRepository.isReceiverLoaded("test"));
        Assertions.assertFalse((boolean)ExceptionThrowingDelegationTokenReceiver.constructed.get());
        Assertions.assertFalse((boolean)delegationTokenReceiverRepository.isReceiverLoaded("throw"));
    }
}

