/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public class TestingAccessExecution
implements AccessExecution {
    private final ExecutionAttemptID executionAttemptID;
    private final ExecutionState state;
    @Nullable
    private final ErrorInfo failureInfo;
    @Nullable
    private final TaskManagerLocation taskManagerLocation;

    private TestingAccessExecution(ExecutionAttemptID executionAttemptID, ExecutionState state, @Nullable ErrorInfo failureInfo, @Nullable TaskManagerLocation taskManagerLocation) {
        this.executionAttemptID = executionAttemptID;
        this.state = state;
        this.failureInfo = failureInfo;
        this.taskManagerLocation = taskManagerLocation;
    }

    public ExecutionAttemptID getAttemptId() {
        return this.executionAttemptID;
    }

    public TaskManagerLocation getAssignedResourceLocation() {
        return this.taskManagerLocation;
    }

    public Optional<ErrorInfo> getFailureInfo() {
        return Optional.ofNullable(this.failureInfo);
    }

    public int getAttemptNumber() {
        throw new UnsupportedOperationException("getAttemptNumber should not be called.");
    }

    public long[] getStateTimestamps() {
        throw new UnsupportedOperationException("getStateTimestamps should not be called.");
    }

    public long[] getStateEndTimestamps() {
        throw new UnsupportedOperationException("getStateTimestamps should not be called.");
    }

    public ExecutionState getState() {
        return this.state;
    }

    public long getStateTimestamp(ExecutionState state) {
        throw new UnsupportedOperationException("getStateTimestamp should not be called.");
    }

    public long getStateEndTimestamp(ExecutionState state) {
        throw new UnsupportedOperationException("getStateTimestamp should not be called.");
    }

    public StringifiedAccumulatorResult[] getUserAccumulatorsStringified() {
        throw new UnsupportedOperationException("getUserAccumulatorsStringified should not be called.");
    }

    public int getParallelSubtaskIndex() {
        throw new UnsupportedOperationException("getParallelSubtaskIndex should not be called.");
    }

    public IOMetrics getIOMetrics() {
        throw new UnsupportedOperationException("getIOMetrics should not be called.");
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ExecutionState state = ExecutionState.CREATED;
        private ExecutionAttemptID attemptId = ExecutionGraphTestUtils.createExecutionAttemptId();
        @Nullable
        private ErrorInfo failureInfo = null;
        @Nullable
        private TaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();

        private Builder() {
        }

        public Builder withAttemptId(ExecutionAttemptID attemptId) {
            this.attemptId = attemptId;
            return this;
        }

        public Builder withExecutionState(ExecutionState state) {
            this.state = state;
            return this;
        }

        public Builder withErrorInfo(ErrorInfo failureInfo) {
            this.failureInfo = failureInfo;
            return this;
        }

        public Builder withTaskManagerLocation(@Nullable TaskManagerLocation taskManagerLocation) {
            this.taskManagerLocation = taskManagerLocation;
            return this;
        }

        public TestingAccessExecution build() {
            return new TestingAccessExecution(this.attemptId, this.state, this.failureInfo, this.taskManagerLocation);
        }
    }
}

