/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.scheduler.adaptivebatch.util.SubpartitionSlice;
import org.apache.flink.runtime.scheduler.adaptivebatch.util.VertexParallelismAndInputInfosDeciderUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class VertexParallelismAndInputInfosDeciderUtilsTest {
    VertexParallelismAndInputInfosDeciderUtilsTest() {
    }

    @Test
    void testCartesianProduct() {
        List inputEmpty = List.of();
        List expectedEmpty = List.of(List.of());
        List resultEmpty = VertexParallelismAndInputInfosDeciderUtils.cartesianProduct(inputEmpty);
        Assertions.assertThat((List)resultEmpty).isEqualTo(expectedEmpty);
        List<List> inputTwo = Arrays.asList(Arrays.asList(1, 2), Arrays.asList(3, 4));
        List<List> expectedTwo = Arrays.asList(Arrays.asList(1, 3), Arrays.asList(1, 4), Arrays.asList(2, 3), Arrays.asList(2, 4));
        List resultTwo = VertexParallelismAndInputInfosDeciderUtils.cartesianProduct(inputTwo);
        Assertions.assertThat((List)resultTwo).isEqualTo(expectedTwo);
        List<List> inputThree = Arrays.asList(Arrays.asList("A", "B"), Arrays.asList("1", "2"), Arrays.asList("X", "Y"));
        List<List> expectedThree = Arrays.asList(Arrays.asList("A", "1", "X"), Arrays.asList("A", "1", "Y"), Arrays.asList("A", "2", "X"), Arrays.asList("A", "2", "Y"), Arrays.asList("B", "1", "X"), Arrays.asList("B", "1", "Y"), Arrays.asList("B", "2", "X"), Arrays.asList("B", "2", "Y"));
        List resultThree = VertexParallelismAndInputInfosDeciderUtils.cartesianProduct(inputThree);
        Assertions.assertThat((List)resultThree).isEqualTo(expectedThree);
    }

    @Test
    void testMedian() {
        long[] numsOdd = new long[]{5L, 1L, 3L};
        long resultOdd = VertexParallelismAndInputInfosDeciderUtils.median((long[])numsOdd);
        Assertions.assertThat((long)resultOdd).isEqualTo(3L);
        long[] numsEven = new long[]{7L, 3L, 9L, 1L};
        long resultEven = VertexParallelismAndInputInfosDeciderUtils.median((long[])numsEven);
        Assertions.assertThat((long)resultEven).isEqualTo(5L);
        long[] numsSame = new long[]{2L, 2L, 2L, 2L, 2L};
        long resultSame = VertexParallelismAndInputInfosDeciderUtils.median((long[])numsSame);
        Assertions.assertThat((long)resultSame).isEqualTo(2L);
        long[] numsSingle = new long[]{8L};
        long resultSingle = VertexParallelismAndInputInfosDeciderUtils.median((long[])numsSingle);
        Assertions.assertThat((long)resultSingle).isEqualTo(8L);
        long[] numsEdges = new long[]{2L, 4L};
        long resultEdges = VertexParallelismAndInputInfosDeciderUtils.median((long[])numsEdges);
        Assertions.assertThat((long)resultEdges).isEqualTo(3L);
        long[] numsLessThanOne = new long[]{1L, 2L, 3L, 0L, 0L};
        long resultLessThanOne = VertexParallelismAndInputInfosDeciderUtils.median((long[])numsLessThanOne);
        Assertions.assertThat((long)resultLessThanOne).isEqualTo(1L);
    }

    @Test
    void computeSkewThresholdTest() {
        long mediaSize1 = 100L;
        double skewedFactor1 = 1.5;
        long defaultSkewedThreshold1 = 50L;
        long result1 = VertexParallelismAndInputInfosDeciderUtils.computeSkewThreshold((long)mediaSize1, (double)skewedFactor1, (long)defaultSkewedThreshold1);
        Assertions.assertThat((long)result1).isEqualTo(150L);
        long mediaSize2 = 40L;
        double skewedFactor2 = 1.0;
        long defaultSkewedThreshold2 = 50L;
        long result2 = VertexParallelismAndInputInfosDeciderUtils.computeSkewThreshold((long)mediaSize2, (double)skewedFactor2, (long)defaultSkewedThreshold2);
        Assertions.assertThat((long)result2).isEqualTo(50L);
    }

    @Test
    void testComputeTargetSize() {
        long[] subpartitionBytes1 = new long[]{100L, 200L, 150L, 50L};
        long skewedThreshold1 = 150L;
        long dataVolumePerTask1 = 75L;
        long result1 = VertexParallelismAndInputInfosDeciderUtils.computeTargetSize((long[])subpartitionBytes1, (long)skewedThreshold1, (long)dataVolumePerTask1);
        Assertions.assertThat((long)result1).isEqualTo(100L);
        long[] subpartitionBytes2 = new long[]{200L, 180L, 70L, 30L};
        long skewedThreshold2 = 100L;
        long dataVolumePerTask2 = 80L;
        long result2 = VertexParallelismAndInputInfosDeciderUtils.computeTargetSize((long[])subpartitionBytes2, (long)skewedThreshold2, (long)dataVolumePerTask2);
        Assertions.assertThat((long)result2).isEqualTo(80L);
        long[] subpartitionBytes3 = new long[]{100L, 50L, 75L};
        long skewedThreshold3 = 200L;
        long dataVolumePerTask3 = 60L;
        long result3 = VertexParallelismAndInputInfosDeciderUtils.computeTargetSize((long[])subpartitionBytes3, (long)skewedThreshold3, (long)dataVolumePerTask3);
        Assertions.assertThat((long)result3).isEqualTo(75L);
    }

    @Test
    void testComputeSubpartitionSliceRange() {
        Map<Integer, List<SubpartitionSlice>> subpartitionSlicesByTypeNumber = Map.of(1, this.createSubpartitionSlices(5, new long[]{100L, 200L, 300L, 200L, 100L}));
        Optional subpartitionSliceRanges = VertexParallelismAndInputInfosDeciderUtils.tryComputeSubpartitionSliceRange((int)1, (int)5, (long)300L, subpartitionSlicesByTypeNumber);
        Assertions.assertThat((Optional)subpartitionSliceRanges).isNotEmpty();
        Assertions.assertThat((List)((List)subpartitionSliceRanges.get())).isEqualTo(List.of(new IndexRange(0, 1), new IndexRange(2, 2), new IndexRange(3, 4)));
        subpartitionSliceRanges = VertexParallelismAndInputInfosDeciderUtils.tryComputeSubpartitionSliceRange((int)1, (int)5, (long)10000L, subpartitionSlicesByTypeNumber);
        Assertions.assertThat((Optional)subpartitionSliceRanges).isNotEmpty();
        Assertions.assertThat((List)((List)subpartitionSliceRanges.get())).isEqualTo(List.of(new IndexRange(0, 4)));
        subpartitionSliceRanges = VertexParallelismAndInputInfosDeciderUtils.tryComputeSubpartitionSliceRange((int)1, (int)5, (long)100L, subpartitionSlicesByTypeNumber);
        Assertions.assertThat((Optional)subpartitionSliceRanges).isNotEmpty();
        Assertions.assertThat((List)((List)subpartitionSliceRanges.get())).isEqualTo(List.of(new IndexRange(0, 0), new IndexRange(1, 1), new IndexRange(2, 2), new IndexRange(3, 3), new IndexRange(4, 4)));
        subpartitionSliceRanges = VertexParallelismAndInputInfosDeciderUtils.tryComputeSubpartitionSliceRange((int)5, (int)5, (long)200L, subpartitionSlicesByTypeNumber);
        Assertions.assertThat((Optional)subpartitionSliceRanges).isNotEmpty();
        Assertions.assertThat((List)((List)subpartitionSliceRanges.get())).isEqualTo(List.of(new IndexRange(0, 0), new IndexRange(1, 1), new IndexRange(2, 2), new IndexRange(3, 3), new IndexRange(4, 4)));
        subpartitionSliceRanges = VertexParallelismAndInputInfosDeciderUtils.tryComputeSubpartitionSliceRange((int)4, (int)4, (long)200L, subpartitionSlicesByTypeNumber);
        Assertions.assertThat((Optional)subpartitionSliceRanges).isNotEmpty();
        Assertions.assertThat((List)((List)subpartitionSliceRanges.get())).isEqualTo(List.of(new IndexRange(0, 0), new IndexRange(1, 1), new IndexRange(2, 2), new IndexRange(3, 4)));
        subpartitionSliceRanges = VertexParallelismAndInputInfosDeciderUtils.tryComputeSubpartitionSliceRange((int)6, (int)6, (long)200L, subpartitionSlicesByTypeNumber);
        Assertions.assertThat((Optional)subpartitionSliceRanges).isEmpty();
    }

    List<SubpartitionSlice> createSubpartitionSlices(int numSlices, long[] dataBytesPerSlice) {
        ArrayList<SubpartitionSlice> subpartitionSlices = new ArrayList<SubpartitionSlice>();
        for (int i = 0; i < numSlices; ++i) {
            subpartitionSlices.add(SubpartitionSlice.createSubpartitionSlice((IndexRange)new IndexRange(0, 0), (IndexRange)new IndexRange(i, i), (long)dataBytesPerSlice[i]));
        }
        return subpartitionSlices;
    }
}

