/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.scheduler.adaptivebatch.BlockingInputInfo;
import org.apache.flink.runtime.scheduler.adaptivebatch.util.AggregatedBlockingInputInfo;
import org.apache.flink.runtime.scheduler.adaptivebatch.util.AllToAllVertexInputInfoComputerTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregatedBlockingInputInfoTest {
    @Test
    void testAggregatedInputWithSameNumPartitions() {
        List<BlockingInputInfo> inputInfos = AllToAllVertexInputInfoComputerTest.createBlockingInputInfos(1, 10, 4, true, true, List.of(Integer.valueOf(1)));
        AggregatedBlockingInputInfo aggregatedBlockingInputInfo = AggregatedBlockingInputInfo.createAggregatedBlockingInputInfo((long)40L, (double)4.0, (long)20L, inputInfos);
        Assertions.assertThat((int)aggregatedBlockingInputInfo.getMaxPartitionNum()).isEqualTo(4);
        Assertions.assertThat((int)aggregatedBlockingInputInfo.getNumSubpartitions()).isEqualTo(3);
        Assertions.assertThat((long)aggregatedBlockingInputInfo.getTargetSize()).isEqualTo(40L);
        Assertions.assertThat((boolean)aggregatedBlockingInputInfo.isSplittable()).isFalse();
        Assertions.assertThat((boolean)aggregatedBlockingInputInfo.isSkewedSubpartition(0)).isEqualTo(false);
        Assertions.assertThat((boolean)aggregatedBlockingInputInfo.isSkewedSubpartition(1)).isEqualTo(true);
        Assertions.assertThat((boolean)aggregatedBlockingInputInfo.isSkewedSubpartition(2)).isEqualTo(false);
        Assertions.assertThat((long)aggregatedBlockingInputInfo.getAggregatedSubpartitionBytes(0)).isEqualTo(40L);
        Assertions.assertThat((long)aggregatedBlockingInputInfo.getAggregatedSubpartitionBytes(1)).isEqualTo(400L);
        Assertions.assertThat((long)aggregatedBlockingInputInfo.getAggregatedSubpartitionBytes(2)).isEqualTo(40L);
        Assertions.assertThat((Map)aggregatedBlockingInputInfo.getSubpartitionBytesByPartition()).isEmpty();
        AggregatedBlockingInputInfo aggregatedBlockingInputInfo2 = AggregatedBlockingInputInfo.createAggregatedBlockingInputInfo((long)30L, (double)4.0, (long)20L, inputInfos);
        Assertions.assertThat((long)aggregatedBlockingInputInfo2.getTargetSize()).isEqualTo(40L);
        AggregatedBlockingInputInfo aggregatedBlockingInputInfo3 = AggregatedBlockingInputInfo.createAggregatedBlockingInputInfo((long)500L, (double)4.0, (long)20L, inputInfos);
        Assertions.assertThat((long)aggregatedBlockingInputInfo3.getTargetSize()).isEqualTo(160L);
        AggregatedBlockingInputInfo aggregatedBlockingInputInfo4 = AggregatedBlockingInputInfo.createAggregatedBlockingInputInfo((long)100L, (double)20.0, (long)20L, inputInfos);
        Assertions.assertThat((long)aggregatedBlockingInputInfo4.getTargetSize()).isEqualTo(160L);
        List<BlockingInputInfo> inputInfosWithoutIntraCorrelation = AllToAllVertexInputInfoComputerTest.createBlockingInputInfos(2, 10, 4, false, true, List.of(Integer.valueOf(1)));
        AggregatedBlockingInputInfo aggregatedBlockingInputInfo5 = AggregatedBlockingInputInfo.createAggregatedBlockingInputInfo((long)40L, (double)4.0, (long)20L, inputInfosWithoutIntraCorrelation);
        Assertions.assertThat((Map)aggregatedBlockingInputInfo5.getSubpartitionBytesByPartition()).containsExactlyInAnyOrderEntriesOf(Map.of(0, new long[]{10L, 100L, 10L}, 1, new long[]{10L, 100L, 10L}, 2, new long[]{10L, 100L, 10L}, 3, new long[]{10L, 100L, 10L}));
    }

    @Test
    void testAggregatedInputWithDifferentNumPartitions() {
        ArrayList<BlockingInputInfo> inputInfos = new ArrayList<BlockingInputInfo>();
        inputInfos.addAll(AllToAllVertexInputInfoComputerTest.createBlockingInputInfos(1, 10, 4, false, true, List.of()));
        inputInfos.addAll(AllToAllVertexInputInfoComputerTest.createBlockingInputInfos(1, 1, 5, false, true, List.of()));
        AggregatedBlockingInputInfo aggregatedBlockingInputInfo = AggregatedBlockingInputInfo.createAggregatedBlockingInputInfo((long)40L, (double)4.0, (long)20L, inputInfos);
        Assertions.assertThat((int)aggregatedBlockingInputInfo.getMaxPartitionNum()).isEqualTo(5);
        Assertions.assertThat((int)aggregatedBlockingInputInfo.getNumSubpartitions()).isEqualTo(3);
        Assertions.assertThat((Map)aggregatedBlockingInputInfo.getSubpartitionBytesByPartition()).isEmpty();
        Assertions.assertThat((boolean)aggregatedBlockingInputInfo.isSplittable()).isFalse();
    }
}

