/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.StateRecoveryOptions;
import org.apache.flink.core.failure.FailureEnricher;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.blob.VoidBlobWriter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CheckpointStatsListener;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.DefaultCheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.executiongraph.failover.NoRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.RestartBackoffTimeStrategy;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.io.network.partition.NoOpJobMasterPartitionTracker;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobResourceRequirements;
import org.apache.flink.runtime.jobmaster.DefaultExecutionDeploymentTracker;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentTracker;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultAllocatedSlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultDeclarativeSlotPool;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.scheduler.DefaultExecutionGraphFactory;
import org.apache.flink.runtime.scheduler.ExecutionGraphFactory;
import org.apache.flink.runtime.scheduler.adaptive.AdaptiveScheduler;
import org.apache.flink.runtime.scheduler.adaptive.AdaptiveSchedulerFactory;
import org.apache.flink.runtime.scheduler.adaptive.DefaultStateTransitionManager;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotAllocator;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.shuffle.ShuffleTestUtils;
import org.apache.flink.util.FatalExitExceptionHandler;

public class AdaptiveSchedulerBuilder {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(300L);
    private final JobGraph jobGraph;
    private final ComponentMainThreadExecutor mainThreadExecutor;
    private final ScheduledExecutorService executorService;
    @Nullable
    private JobResourceRequirements jobResourceRequirements;
    private Configuration jobMasterConfiguration = new Configuration();
    private ClassLoader userCodeLoader = ClassLoader.getSystemClassLoader();
    private CheckpointsCleaner checkpointsCleaner = new CheckpointsCleaner();
    private CheckpointRecoveryFactory checkpointRecoveryFactory = new StandaloneCheckpointRecoveryFactory();
    private DeclarativeSlotPool declarativeSlotPool;
    private Duration rpcTimeout = DEFAULT_TIMEOUT;
    private BlobWriter blobWriter = VoidBlobWriter.getInstance();
    private JobManagerJobMetricGroup jobManagerJobMetricGroup = UnregisteredMetricGroups.createUnregisteredJobManagerJobMetricGroup();
    private ShuffleMaster<?> shuffleMaster = ShuffleTestUtils.DEFAULT_SHUFFLE_MASTER;
    private JobMasterPartitionTracker partitionTracker = NoOpJobMasterPartitionTracker.INSTANCE;
    private RestartBackoffTimeStrategy restartBackoffTimeStrategy = NoRestartBackoffTimeStrategy.INSTANCE;
    private FatalErrorHandler fatalErrorHandler = error -> FatalExitExceptionHandler.INSTANCE.uncaughtException(Thread.currentThread(), error);
    private JobStatusListener jobStatusListener = (ignoredA, ignoredB, ignoredC) -> {};
    private Collection<FailureEnricher> failureEnrichers = Collections.emptySet();
    private long initializationTimestamp = System.currentTimeMillis();
    @Nullable
    private SlotAllocator slotAllocator;
    @Nullable
    private AdaptiveScheduler.StateTransitionManagerFactory stateTransitionManagerFactory = null;
    private BiFunction<JobManagerJobMetricGroup, CheckpointStatsListener, CheckpointStatsTracker> checkpointStatsTrackerFactory = (metricGroup, checkpointStatsListener) -> new DefaultCheckpointStatsTracker(10, metricGroup, checkpointStatsListener);

    public AdaptiveSchedulerBuilder(JobGraph jobGraph, ComponentMainThreadExecutor mainThreadExecutor, ScheduledExecutorService executorService) {
        this.jobGraph = jobGraph;
        this.mainThreadExecutor = mainThreadExecutor;
        this.declarativeSlotPool = new DefaultDeclarativeSlotPool(jobGraph.getJobID(), (AllocatedSlotPool)new DefaultAllocatedSlotPool(), ignored -> {}, DEFAULT_TIMEOUT, this.rpcTimeout, Duration.ZERO, mainThreadExecutor);
        this.executorService = executorService;
    }

    public AdaptiveSchedulerBuilder setJobResourceRequirements(JobResourceRequirements jobResourceRequirements) {
        this.jobResourceRequirements = jobResourceRequirements;
        return this;
    }

    public AdaptiveSchedulerBuilder setJobMasterConfiguration(Configuration jobMasterConfiguration) {
        this.jobMasterConfiguration = jobMasterConfiguration;
        return this;
    }

    public AdaptiveSchedulerBuilder withConfigurationOverride(Function<Configuration, Configuration> modifyFn) {
        this.jobMasterConfiguration = modifyFn.apply(this.jobMasterConfiguration);
        return this;
    }

    public AdaptiveSchedulerBuilder setUserCodeLoader(ClassLoader userCodeLoader) {
        this.userCodeLoader = userCodeLoader;
        return this;
    }

    public AdaptiveSchedulerBuilder setCheckpointCleaner(CheckpointsCleaner checkpointsCleaner) {
        this.checkpointsCleaner = checkpointsCleaner;
        return this;
    }

    public AdaptiveSchedulerBuilder setCheckpointRecoveryFactory(CheckpointRecoveryFactory checkpointRecoveryFactory) {
        this.checkpointRecoveryFactory = checkpointRecoveryFactory;
        return this;
    }

    public AdaptiveSchedulerBuilder setRpcTimeout(Duration rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
        return this;
    }

    public AdaptiveSchedulerBuilder setBlobWriter(BlobWriter blobWriter) {
        this.blobWriter = blobWriter;
        return this;
    }

    public AdaptiveSchedulerBuilder setJobManagerJobMetricGroup(JobManagerJobMetricGroup jobManagerJobMetricGroup) {
        this.jobManagerJobMetricGroup = jobManagerJobMetricGroup;
        return this;
    }

    public AdaptiveSchedulerBuilder setShuffleMaster(ShuffleMaster<?> shuffleMaster) {
        this.shuffleMaster = shuffleMaster;
        return this;
    }

    public AdaptiveSchedulerBuilder setPartitionTracker(JobMasterPartitionTracker partitionTracker) {
        this.partitionTracker = partitionTracker;
        return this;
    }

    public AdaptiveSchedulerBuilder setDeclarativeSlotPool(DeclarativeSlotPool declarativeSlotPool) {
        this.declarativeSlotPool = declarativeSlotPool;
        return this;
    }

    public AdaptiveSchedulerBuilder setRestartBackoffTimeStrategy(RestartBackoffTimeStrategy restartBackoffTimeStrategy) {
        this.restartBackoffTimeStrategy = restartBackoffTimeStrategy;
        return this;
    }

    public AdaptiveSchedulerBuilder setFatalErrorHandler(FatalErrorHandler fatalErrorHandler) {
        this.fatalErrorHandler = fatalErrorHandler;
        return this;
    }

    public AdaptiveSchedulerBuilder setJobStatusListener(JobStatusListener jobStatusListener) {
        this.jobStatusListener = jobStatusListener;
        return this;
    }

    public AdaptiveSchedulerBuilder setFailureEnrichers(Collection<FailureEnricher> failureEnrichers) {
        this.failureEnrichers = failureEnrichers;
        return this;
    }

    public AdaptiveSchedulerBuilder setInitializationTimestamp(long initializationTimestamp) {
        this.initializationTimestamp = initializationTimestamp;
        return this;
    }

    public AdaptiveSchedulerBuilder setSlotAllocator(SlotAllocator slotAllocator) {
        this.slotAllocator = slotAllocator;
        return this;
    }

    public AdaptiveSchedulerBuilder setStateTransitionManagerFactory(@Nullable AdaptiveScheduler.StateTransitionManagerFactory stateTransitionManagerFactory) {
        this.stateTransitionManagerFactory = stateTransitionManagerFactory;
        return this;
    }

    public AdaptiveSchedulerBuilder setCheckpointStatsTrackerFactory(@Nullable BiFunction<JobManagerJobMetricGroup, CheckpointStatsListener, CheckpointStatsTracker> checkpointStatsTrackerFactory) {
        this.checkpointStatsTrackerFactory = checkpointStatsTrackerFactory;
        return this;
    }

    public AdaptiveScheduler build() throws Exception {
        DefaultExecutionGraphFactory executionGraphFactory = new DefaultExecutionGraphFactory(this.jobMasterConfiguration, this.userCodeLoader, (ExecutionDeploymentTracker)new DefaultExecutionDeploymentTracker(), this.executorService, (Executor)this.executorService, this.rpcTimeout, this.jobManagerJobMetricGroup, this.blobWriter, this.shuffleMaster, this.partitionTracker);
        AdaptiveScheduler.Settings settings = AdaptiveScheduler.Settings.of((Configuration)this.jobMasterConfiguration);
        return new AdaptiveScheduler(settings, this.stateTransitionManagerFactory == null ? DefaultStateTransitionManager::new : this.stateTransitionManagerFactory, this.checkpointStatsTrackerFactory, this.jobGraph, this.jobResourceRequirements, this.jobMasterConfiguration, this.declarativeSlotPool, (SlotAllocator)(this.slotAllocator == null ? AdaptiveSchedulerFactory.createSlotSharingSlotAllocator((DeclarativeSlotPool)this.declarativeSlotPool, (boolean)((Boolean)this.jobMasterConfiguration.get(StateRecoveryOptions.LOCAL_RECOVERY)), (String)((String)this.jobMasterConfiguration.get(DeploymentOptions.TARGET)), (boolean)((Boolean)this.jobMasterConfiguration.get(JobManagerOptions.SCHEDULER_PREFER_MINIMAL_TASKMANAGERS_ENABLED))) : this.slotAllocator), (Executor)this.executorService, this.userCodeLoader, this.checkpointsCleaner, this.checkpointRecoveryFactory, this.jobManagerJobMetricGroup, this.restartBackoffTimeStrategy, this.initializationTimestamp, this.mainThreadExecutor, this.fatalErrorHandler, this.jobStatusListener, this.failureEnrichers, (ExecutionGraphFactory)executionGraphFactory);
    }
}

