/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import org.apache.flink.runtime.metrics.groups.SlotManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultResourceTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultSlotStatusSyncer;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedSlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedTaskManagerTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceAllocationStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfigurationBuilder;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotStatusSyncer;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingResourceAllocationStrategy;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.util.concurrent.ScheduledExecutor;

public class FineGrainedSlotManagerBuilder {
    private ResourceTracker resourceTracker = new DefaultResourceTracker();
    private TaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
    private SlotStatusSyncer slotStatusSyncer = new DefaultSlotStatusSyncer(TestingUtils.infiniteTime());
    private SlotManagerMetricGroup slotManagerMetricGroup = UnregisteredMetricGroups.createUnregisteredSlotManagerMetricGroup();
    private final ScheduledExecutor scheduledExecutor;
    private ResourceAllocationStrategy resourceAllocationStrategy = TestingResourceAllocationStrategy.newBuilder().build();
    SlotManagerConfiguration slotManagerConfiguration = SlotManagerConfigurationBuilder.newBuilder().build();

    private FineGrainedSlotManagerBuilder(ScheduledExecutor scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
    }

    public static FineGrainedSlotManagerBuilder newBuilder(ScheduledExecutor scheduledExecutor) {
        return new FineGrainedSlotManagerBuilder(scheduledExecutor);
    }

    public FineGrainedSlotManagerBuilder setTaskManagerTracker(TaskManagerTracker taskManagerTracker) {
        this.taskManagerTracker = taskManagerTracker;
        return this;
    }

    public FineGrainedSlotManagerBuilder setSlotManagerMetricGroup(SlotManagerMetricGroup slotManagerMetricGroup) {
        this.slotManagerMetricGroup = slotManagerMetricGroup;
        return this;
    }

    public FineGrainedSlotManagerBuilder setResourceTracker(ResourceTracker resourceTracker) {
        this.resourceTracker = resourceTracker;
        return this;
    }

    public FineGrainedSlotManagerBuilder setSlotStatusSyncer(SlotStatusSyncer slotStatusSyncer) {
        this.slotStatusSyncer = slotStatusSyncer;
        return this;
    }

    public FineGrainedSlotManagerBuilder setResourceAllocationStrategy(ResourceAllocationStrategy resourceAllocationStrategy) {
        this.resourceAllocationStrategy = resourceAllocationStrategy;
        return this;
    }

    public FineGrainedSlotManagerBuilder setSlotManagerConfiguration(SlotManagerConfiguration slotManagerConfiguration) {
        this.slotManagerConfiguration = slotManagerConfiguration;
        return this;
    }

    public FineGrainedSlotManager build() {
        return new FineGrainedSlotManager(this.scheduledExecutor, this.slotManagerConfiguration, this.slotManagerMetricGroup, this.resourceTracker, this.taskManagerTracker, this.slotStatusSyncer, this.resourceAllocationStrategy);
    }
}

