/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfileTestingUtils;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridge;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridgeBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProviderExtension;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProviderImpl;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequest;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class PhysicalSlotProviderImplWithSpreadOutStrategyTest {
    @RegisterExtension
    private PhysicalSlotProviderExtension physicalSlotProviderExtension = new PhysicalSlotProviderExtension((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createEvenlySpreadOut());

    PhysicalSlotProviderImplWithSpreadOutStrategyTest() {
    }

    @Test
    void testSlotAllocationFulfilledWithWorkloadSpreadOut() throws InterruptedException, ExecutionException {
        this.physicalSlotProviderExtension.registerSlotOffersFromNewTaskExecutor(ResourceProfile.ANY, ResourceProfile.ANY, ResourceProfile.ANY, ResourceProfile.ANY);
        this.physicalSlotProviderExtension.registerSlotOffersFromNewTaskExecutor(ResourceProfile.ANY, ResourceProfile.ANY, ResourceProfile.ANY, ResourceProfile.ANY);
        PhysicalSlotRequest request0 = this.physicalSlotProviderExtension.createSimpleRequest();
        PhysicalSlotRequest request1 = this.physicalSlotProviderExtension.createSimpleRequest();
        PhysicalSlotRequest.Result result0 = this.physicalSlotProviderExtension.allocateSlot(request0).get();
        PhysicalSlotRequest.Result result1 = this.physicalSlotProviderExtension.allocateSlot(request1).get();
        Assertions.assertThat((Comparable)result0.getPhysicalSlot().getTaskManagerLocation()).isNotEqualTo((Object)result1.getPhysicalSlot().getTaskManagerLocation());
    }

    @Test
    void testSlotAllocationFulfilledWithPreferredInputOverwrittingSpreadOut() throws ExecutionException, InterruptedException {
        this.physicalSlotProviderExtension.registerSlotOffersFromNewTaskExecutor(ResourceProfile.ANY, ResourceProfile.ANY);
        this.physicalSlotProviderExtension.registerSlotOffersFromNewTaskExecutor(ResourceProfile.ANY, ResourceProfile.ANY);
        PhysicalSlotRequest request0 = this.physicalSlotProviderExtension.createSimpleRequest();
        PhysicalSlotRequest.Result result0 = this.physicalSlotProviderExtension.allocateSlot(request0).get();
        TaskManagerLocation preferredTaskManagerLocation = result0.getPhysicalSlot().getTaskManagerLocation();
        PhysicalSlotRequest request1 = new PhysicalSlotRequest(new SlotRequestId(), SlotProfileTestingUtils.preferredLocality(ResourceProfile.ANY, Collections.singleton(preferredTaskManagerLocation)), false);
        PhysicalSlotRequest.Result result1 = this.physicalSlotProviderExtension.allocateSlot(request1).get();
        Assertions.assertThat((Comparable)result1.getPhysicalSlot().getTaskManagerLocation()).isEqualTo((Object)preferredTaskManagerLocation);
    }

    @Test
    void testSlotAllocationFulfilledWithNewSlots() throws ExecutionException, InterruptedException {
        CompletableFuture<PhysicalSlotRequest.Result> slotFuture = this.physicalSlotProviderExtension.allocateSlot(this.physicalSlotProviderExtension.createSimpleRequest());
        FlinkAssertions.assertThatFuture(slotFuture).isNotDone();
        this.physicalSlotProviderExtension.registerSlotOffersFromNewTaskExecutor(ResourceProfile.ANY);
        slotFuture.get();
    }

    @Test
    void testIndividualBatchSlotRequestTimeoutCheckIsDisabledOnAllocatingNewSlots() throws Exception {
        DeclarativeSlotPoolBridge slotPool = new DeclarativeSlotPoolBridgeBuilder().setMainThreadExecutor(this.physicalSlotProviderExtension.getMainThreadExecutor()).buildAndStart();
        Assertions.assertThat((boolean)slotPool.isBatchSlotRequestTimeoutCheckEnabled()).isTrue();
        PhysicalSlotProviderImpl slotProvider = new PhysicalSlotProviderImpl((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createEvenlySpreadOut(), (SlotPool)slotPool);
        slotProvider.disableBatchSlotRequestTimeoutCheck();
        Assertions.assertThat((boolean)slotPool.isBatchSlotRequestTimeoutCheckEnabled()).isFalse();
    }
}

