/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import org.apache.flink.runtime.jobmaster.slotpool.AbstractServiceConnectionManager;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AbstractServiceConnectionManagerTest {
    AbstractServiceConnectionManagerTest() {
    }

    @Test
    void testIsConnected() {
        TestServiceConnectionManager connectionManager = new TestServiceConnectionManager();
        Assertions.assertThat((boolean)connectionManager.isConnected()).isFalse();
        connectionManager.connect(new Object());
        Assertions.assertThat((boolean)connectionManager.isConnected()).isTrue();
        connectionManager.disconnect();
        Assertions.assertThat((boolean)connectionManager.isConnected()).isFalse();
        connectionManager.close();
        Assertions.assertThat((boolean)connectionManager.isConnected()).isFalse();
    }

    @Test
    void testCheckNotClosed() {
        TestServiceConnectionManager connectionManager = new TestServiceConnectionManager();
        connectionManager.checkNotClosed();
        connectionManager.connect(new Object());
        connectionManager.checkNotClosed();
        connectionManager.disconnect();
        connectionManager.checkNotClosed();
        connectionManager.close();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((AbstractServiceConnectionManager)connectionManager).checkNotClosed()).as("checkNotClosed() did not fail for a closed connection manager", new Object[0])).isInstanceOf(IllegalStateException.class);
    }

    private static class TestServiceConnectionManager
    extends AbstractServiceConnectionManager<Object> {
        private TestServiceConnectionManager() {
        }
    }
}

