/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.file;

import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.CompositeBuffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileReader;

public class TestingPartitionFileReader
implements PartitionFileReader {
    private final BiFunction<Integer, Integer, PartitionFileReader.ReadBufferResult> readBufferFunction;
    private final Function<Integer, Long> getPriorityFunction;
    private final Runnable releaseRunnable;

    private TestingPartitionFileReader(BiFunction<Integer, Integer, PartitionFileReader.ReadBufferResult> readBufferFunction, Function<Integer, Long> getPriorityFunction, Runnable releaseRunnable) {
        this.readBufferFunction = readBufferFunction;
        this.getPriorityFunction = getPriorityFunction;
        this.releaseRunnable = releaseRunnable;
    }

    public PartitionFileReader.ReadBufferResult readBuffer(TieredStoragePartitionId partitionId, TieredStorageSubpartitionId subpartitionId, int segmentId, int bufferIndex, MemorySegment memorySegment, BufferRecycler recycler, @Nullable PartitionFileReader.ReadProgress readProgress, @Nullable CompositeBuffer partialBuffer) throws IOException {
        return this.readBufferFunction.apply(bufferIndex, segmentId);
    }

    public long getPriority(TieredStoragePartitionId partitionId, TieredStorageSubpartitionId subpartitionId, int segmentId, int bufferIndex, @Nullable PartitionFileReader.ReadProgress readProgress) throws IOException {
        return this.getPriorityFunction.apply(subpartitionId.getSubpartitionId());
    }

    public void release() {
        this.releaseRunnable.run();
    }

    public static class Builder {
        private BiFunction<Integer, Integer, PartitionFileReader.ReadBufferResult> readBufferSupplier = (bufferIndex, segmentId) -> null;
        private Function<Integer, Long> prioritySupplier = bufferIndex -> 0L;
        private Runnable releaseNotifier = () -> {};

        public Builder setReadBufferSupplier(BiFunction<Integer, Integer, PartitionFileReader.ReadBufferResult> readBufferSupplier) {
            this.readBufferSupplier = readBufferSupplier;
            return this;
        }

        public Builder setPrioritySupplier(Function<Integer, Long> prioritySupplier) {
            this.prioritySupplier = prioritySupplier;
            return this;
        }

        public Builder setReleaseNotifier(Runnable releaseNotifier) {
            this.releaseNotifier = releaseNotifier;
            return this;
        }

        public TestingPartitionFileReader build() {
            return new TestingPartitionFileReader(this.readBufferSupplier, this.prioritySupplier, this.releaseNotifier);
        }
    }
}

