/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.TestingBlobWriter;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.util.CompressedSerializedValue;

public class TaskDeploymentDescriptorTestUtils {
    public static ShuffleDescriptor[] deserializeShuffleDescriptors(List<TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup>> maybeOffloaded, JobID jobId, TestingBlobWriter blobWriter) throws IOException, ClassNotFoundException {
        HashMap<Integer, ShuffleDescriptor> shuffleDescriptorsMap = new HashMap<Integer, ShuffleDescriptor>();
        int maxIndex = 0;
        for (TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup> sd : maybeOffloaded) {
            TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup shuffleDescriptorGroup;
            if (sd instanceof TaskDeploymentDescriptor.NonOffloaded) {
                shuffleDescriptorGroup = (TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup)((TaskDeploymentDescriptor.NonOffloaded)sd).serializedValue.deserializeValue(ClassLoader.getSystemClassLoader());
            } else {
                CompressedSerializedValue compressedSerializedValue = CompressedSerializedValue.fromBytes((byte[])blobWriter.getBlob(jobId, ((TaskDeploymentDescriptor.Offloaded)sd).serializedValueKey));
                shuffleDescriptorGroup = (TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup)compressedSerializedValue.deserializeValue(ClassLoader.getSystemClassLoader());
            }
            for (TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex shuffleDescriptorAndIndex : shuffleDescriptorGroup.getShuffleDescriptors()) {
                int index = shuffleDescriptorAndIndex.getIndex();
                maxIndex = Math.max(maxIndex, shuffleDescriptorAndIndex.getIndex());
                shuffleDescriptorsMap.put(index, shuffleDescriptorAndIndex.getShuffleDescriptor());
            }
        }
        ShuffleDescriptor[] shuffleDescriptors = new ShuffleDescriptor[maxIndex + 1];
        shuffleDescriptorsMap.forEach((key, value) -> {
            shuffleDescriptors[key.intValue()] = value;
        });
        return shuffleDescriptors;
    }
}

