/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.util.Collection;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;

public class ChannelStateWriteResultUtil {
    public static void assertHasSpecialCause(ChannelStateWriter.ChannelStateWriteResult result, Class<? extends Throwable> type) {
        Assertions.assertThatThrownBy(() -> result.getInputChannelStateHandles().get()).hasCauseInstanceOf(type);
        Assertions.assertThatThrownBy(() -> result.getResultSubpartitionStateHandles().get()).hasCauseInstanceOf(type);
    }

    public static void assertCheckpointFailureReason(ChannelStateWriter.ChannelStateWriteResult result, CheckpointFailureReason checkpointFailureReason) {
        ((ObjectAssert)Assertions.assertThatThrownBy(() -> result.getInputChannelStateHandles().get()).cause().asInstanceOf(InstanceOfAssertFactories.type(CheckpointException.class))).satisfies(new ThrowingConsumer[]{checkpointException -> Assertions.assertThat((Comparable)checkpointException.getCheckpointFailureReason()).isEqualTo((Object)checkpointFailureReason)});
        ((ObjectAssert)Assertions.assertThatThrownBy(() -> result.getResultSubpartitionStateHandles().get()).cause().asInstanceOf(InstanceOfAssertFactories.type(CheckpointException.class))).satisfies(new ThrowingConsumer[]{checkpointException -> Assertions.assertThat((Comparable)checkpointException.getCheckpointFailureReason()).isEqualTo((Object)checkpointFailureReason)});
    }

    public static void assertAllSubtaskDoneNormally(Collection<ChannelStateWriter.ChannelStateWriteResult> results) {
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat(results).allMatch(ChannelStateWriter.ChannelStateWriteResult::isDone)).allMatch(result -> !result.getInputChannelStateHandles().isCompletedExceptionally())).allMatch(result -> !result.getResultSubpartitionStateHandles().isCompletedExceptionally());
    }

    public static void assertAllSubtaskNotDone(Collection<ChannelStateWriter.ChannelStateWriteResult> results) {
        Assertions.assertThat(results).allMatch(result -> !result.isDone());
    }
}

