/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.PartitionWindowedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.operators.MapPartitionOperator;
import org.apache.flink.streaming.api.operators.PartitionAggregateOperator;
import org.apache.flink.streaming.api.operators.PartitionReduceOperator;
import org.apache.flink.streaming.api.operators.sortpartition.SortPartitionOperator;
import org.apache.flink.util.Preconditions;

@Internal
public class NonKeyedPartitionWindowedStream<T>
implements PartitionWindowedStream<T> {
    private final StreamExecutionEnvironment environment;
    private final DataStream<T> input;

    public NonKeyedPartitionWindowedStream(StreamExecutionEnvironment environment, DataStream<T> input) {
        this.environment = environment;
        this.input = input;
    }

    @Override
    public <R> SingleOutputStreamOperator<R> mapPartition(MapPartitionFunction<T, R> mapPartitionFunction) {
        if (mapPartitionFunction == null) {
            throw new NullPointerException("The map partition function must not be null.");
        }
        mapPartitionFunction = this.environment.clean(mapPartitionFunction);
        String opName = "MapPartition";
        TypeInformation resultType = TypeExtractor.getMapPartitionReturnTypes(mapPartitionFunction, this.input.getType(), (String)opName, (boolean)true);
        return this.input.transform(opName, resultType, new MapPartitionOperator<T, R>(mapPartitionFunction)).disableChaining().setParallelism(this.input.getParallelism());
    }

    @Override
    public SingleOutputStreamOperator<T> reduce(ReduceFunction<T> reduceFunction) {
        Preconditions.checkNotNull(reduceFunction, (String)"The reduce function must not be null.");
        reduceFunction = this.environment.clean(reduceFunction);
        String opName = "PartitionReduce";
        return this.input.transform(opName, this.input.getTransformation().getOutputType(), new PartitionReduceOperator<T>(reduceFunction)).setParallelism(this.input.getParallelism());
    }

    @Override
    public <ACC, R> SingleOutputStreamOperator<R> aggregate(AggregateFunction<T, ACC, R> aggregateFunction) {
        Preconditions.checkNotNull(aggregateFunction, (String)"The aggregate function must not be null.");
        aggregateFunction = this.environment.clean(aggregateFunction);
        String opName = "PartitionAggregate";
        TypeInformation resultType = TypeExtractor.getAggregateFunctionReturnType(aggregateFunction, this.input.getType(), (String)opName, (boolean)true);
        return this.input.transform(opName, resultType, new PartitionAggregateOperator<T, ACC, R>(aggregateFunction)).setParallelism(this.input.getParallelism());
    }

    @Override
    public SingleOutputStreamOperator<T> sortPartition(int field, Order order) {
        Preconditions.checkNotNull((Object)order, (String)"The order must not be null.");
        Preconditions.checkArgument((field > 0 ? 1 : 0) != 0, (Object)"The field mustn't be less than zero.");
        SortPartitionOperator<T> operator = new SortPartitionOperator<T>(this.input.getType(), field, order);
        String opName = "SortPartition";
        SingleOutputStreamOperator<T> result = this.input.transform("SortPartition", this.input.getType(), operator).setParallelism(this.input.getParallelism());
        int managedMemoryWeight = Math.max(1, ((MemorySize)this.environment.getConfiguration().get(ExecutionOptions.SORT_PARTITION_MEMORY)).getMebiBytes());
        result.getTransformation().declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase.OPERATOR, managedMemoryWeight);
        return result;
    }

    @Override
    public SingleOutputStreamOperator<T> sortPartition(String field, Order order) {
        Preconditions.checkNotNull((Object)field, (String)"The field must not be null.");
        Preconditions.checkNotNull((Object)order, (String)"The order must not be null.");
        SortPartitionOperator<T> operator = new SortPartitionOperator<T>(this.input.getType(), field, order);
        String opName = "SortPartition";
        SingleOutputStreamOperator<T> result = this.input.transform("SortPartition", this.input.getType(), operator).setParallelism(this.input.getParallelism());
        int managedMemoryWeight = Math.max(1, ((MemorySize)this.environment.getConfiguration().get(ExecutionOptions.SORT_PARTITION_MEMORY)).getMebiBytes());
        result.getTransformation().declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase.OPERATOR, managedMemoryWeight);
        return result;
    }

    @Override
    public <K> SingleOutputStreamOperator<T> sortPartition(KeySelector<T, K> keySelector, Order order) {
        Preconditions.checkNotNull(keySelector, (String)"The field must not be null.");
        Preconditions.checkNotNull((Object)order, (String)"The order must not be null.");
        SortPartitionOperator<T> operator = new SortPartitionOperator<T>(this.input.getType(), this.environment.clean(keySelector), order);
        String opName = "SortPartition";
        SingleOutputStreamOperator<T> result = this.input.transform("SortPartition", this.input.getType(), operator).setParallelism(this.input.getParallelism());
        int managedMemoryWeight = Math.max(1, ((MemorySize)this.environment.getConfiguration().get(ExecutionOptions.SORT_PARTITION_MEMORY)).getMebiBytes());
        result.getTransformation().declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase.OPERATOR, managedMemoryWeight);
        return result;
    }
}

