/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MetricStore {
    private static final Logger LOG = LoggerFactory.getLogger(MetricStore.class);
    private static final Set<String> TRANSIENT_METRIC_NAMES = new HashSet<String>(Arrays.asList("idleTimeMsPerSecond", "backPressuredTimeMsPerSecond", "busyTimeMsPerSecond"));
    private final ComponentMetricStore jobManager = new ComponentMetricStore();
    private final Map<String, TaskManagerMetricStore> taskManagers = new ConcurrentHashMap<String, TaskManagerMetricStore>();
    private final Map<String, JobMetricStore> jobs = new ConcurrentHashMap<String, JobMetricStore>();
    private final Map<String, Map<String, Map<Integer, Integer>>> representativeAttempts = new ConcurrentHashMap<String, Map<String, Map<Integer, Integer>>>();

    synchronized void retainTaskManagers(List<String> activeTaskManagers) {
        this.taskManagers.keySet().retainAll(activeTaskManagers);
    }

    synchronized void retainJobs(List<String> activeJobs) {
        this.jobs.keySet().retainAll(activeJobs);
        this.representativeAttempts.keySet().retainAll(activeJobs);
    }

    public synchronized void updateCurrentExecutionAttempts(Collection<JobDetails> jobs) {
        for (JobDetails job : jobs) {
            String jobId = job.getJobId().toString();
            Map<String, Map<Integer, JobDetails.CurrentAttempts>> currentAttempts = job.getCurrentExecutionAttempts();
            Map jobRepresentativeAttempts = this.representativeAttempts.compute(jobId, (k, overwritten) -> CollectionUtil.newHashMapWithExpectedSize((int)currentAttempts.size()));
            currentAttempts.forEach((vertexId, subtaskAttempts) -> {
                Map vertexAttempts = jobRepresentativeAttempts.compute(vertexId, (k, overwritten) -> new HashMap());
                Optional<TaskMetricStore> taskMetricStoreOptional = Optional.ofNullable(this.jobs.get(jobId)).map(map -> map.getTaskMetricStore((String)vertexId));
                taskMetricStoreOptional.ifPresent(taskMetricStore -> taskMetricStore.retainSubtasks(subtaskAttempts.keySet()));
                subtaskAttempts.forEach((subtaskIndex, attempts) -> {
                    vertexAttempts.put(subtaskIndex, attempts.getRepresentativeAttempt());
                    taskMetricStoreOptional.map(taskMetricStore -> taskMetricStore.getSubtaskMetricStore((int)subtaskIndex)).ifPresent(subtaskMetricStore -> subtaskMetricStore.retainAttempts(attempts.getCurrentAttempts()));
                    if (attempts.isTerminalState()) {
                        taskMetricStoreOptional.ifPresent(taskMetricStore -> taskMetricStore.removeTransientMetrics((int)subtaskIndex));
                    }
                });
            });
        }
    }

    public Map<String, Map<String, Map<Integer, Integer>>> getRepresentativeAttempts() {
        return this.representativeAttempts;
    }

    synchronized void addAll(List<MetricDump> metricDumps) {
        for (MetricDump metric : metricDumps) {
            this.add(metric);
        }
    }

    public synchronized ComponentMetricStore getJobManagerMetricStore() {
        return ComponentMetricStore.unmodifiable(this.jobManager);
    }

    public synchronized ComponentMetricStore getJobManagerOperatorMetricStore(String jobID, String taskID) {
        if (jobID == null || taskID == null) {
            return null;
        }
        JobMetricStore job = this.jobs.get(jobID);
        if (job == null) {
            return null;
        }
        TaskMetricStore task = job.getTaskMetricStore(taskID);
        if (task == null) {
            return null;
        }
        return ComponentMetricStore.unmodifiable(task.getJobManagerOperatorMetricStore());
    }

    public synchronized TaskManagerMetricStore getTaskManagerMetricStore(String tmID) {
        return tmID == null ? null : TaskManagerMetricStore.unmodifiable(this.taskManagers.get(tmID));
    }

    public synchronized ComponentMetricStore getJobMetricStore(String jobID) {
        return jobID == null ? null : ComponentMetricStore.unmodifiable(this.jobs.get(jobID));
    }

    public synchronized TaskMetricStore getTaskMetricStore(String jobID, String taskID) {
        JobMetricStore job;
        JobMetricStore jobMetricStore = job = jobID == null ? null : this.jobs.get(jobID);
        if (job == null || taskID == null) {
            return null;
        }
        return TaskMetricStore.unmodifiable(job.getTaskMetricStore(taskID));
    }

    public synchronized ComponentMetricStore getSubtaskMetricStore(String jobID, String taskID, int subtaskIndex) {
        JobMetricStore job;
        JobMetricStore jobMetricStore = job = jobID == null ? null : this.jobs.get(jobID);
        if (job == null) {
            return null;
        }
        TaskMetricStore task = job.getTaskMetricStore(taskID);
        if (task == null) {
            return null;
        }
        return SubtaskMetricStore.unmodifiable(task.getSubtaskMetricStore(subtaskIndex));
    }

    public synchronized ComponentMetricStore getSubtaskAttemptMetricStore(String jobID, String taskID, int subtaskIndex, int attemptNumber) {
        JobMetricStore job;
        JobMetricStore jobMetricStore = job = jobID == null ? null : this.jobs.get(jobID);
        if (job == null) {
            return null;
        }
        TaskMetricStore task = job.getTaskMetricStore(taskID);
        if (task == null) {
            return null;
        }
        SubtaskMetricStore subtask = task.getSubtaskMetricStore(subtaskIndex);
        if (subtask == null) {
            return null;
        }
        return ComponentMetricStore.unmodifiable(subtask.getAttemptsMetricStore(attemptNumber));
    }

    public synchronized Map<String, JobMetricStore> getJobs() {
        return Collections.unmodifiableMap(this.jobs);
    }

    public synchronized Map<String, TaskManagerMetricStore> getTaskManagers() {
        return Collections.unmodifiableMap(this.taskManagers);
    }

    @VisibleForTesting
    public void add(MetricDump metric) {
        try {
            String name;
            QueryScopeInfo info = metric.scopeInfo;
            String string = name = info.scope.isEmpty() ? metric.name : info.scope + "." + metric.name;
            if (name.isEmpty()) {
                return;
            }
            switch (info.getCategory()) {
                case 0: {
                    this.addMetric(this.jobManager, name, metric);
                    break;
                }
                case 1: {
                    String tmID = ((QueryScopeInfo.TaskManagerQueryScopeInfo)info).taskManagerID;
                    TaskManagerMetricStore tm = this.taskManagers.computeIfAbsent(tmID, k -> new TaskManagerMetricStore());
                    if (name.contains("GarbageCollector")) {
                        String gcName = name.substring("Status.JVM.GarbageCollector.".length(), name.lastIndexOf(46));
                        tm.addGarbageCollectorName(gcName);
                    }
                    this.addMetric(tm, name, metric);
                    break;
                }
                case 2: {
                    QueryScopeInfo.JobQueryScopeInfo jobInfo = (QueryScopeInfo.JobQueryScopeInfo)info;
                    JobMetricStore job = this.jobs.computeIfAbsent(jobInfo.jobID, k -> new JobMetricStore());
                    this.addMetric(job, name, metric);
                    break;
                }
                case 3: {
                    QueryScopeInfo.TaskQueryScopeInfo taskInfo = (QueryScopeInfo.TaskQueryScopeInfo)info;
                    JobMetricStore job = this.jobs.computeIfAbsent(taskInfo.jobID, k -> new JobMetricStore());
                    TaskMetricStore task = job.tasks.computeIfAbsent(taskInfo.vertexID, k -> new TaskMetricStore());
                    SubtaskMetricStore subtask = task.subtasks.computeIfAbsent(taskInfo.subtaskIndex, k -> new SubtaskMetricStore());
                    boolean isRepresentativeAttempt = this.isRepresentativeAttempt(taskInfo.jobID, taskInfo.vertexID, taskInfo.subtaskIndex, taskInfo.attemptNumber);
                    ComponentMetricStore attempt = subtask.attempts.computeIfAbsent(taskInfo.attemptNumber, k -> new ComponentMetricStore());
                    this.addMetric(attempt, name, metric);
                    if (isRepresentativeAttempt) {
                        this.addMetric(subtask, name, metric);
                        this.addMetric(task, taskInfo.subtaskIndex + "." + name, metric);
                    }
                    break;
                }
                case 4: {
                    QueryScopeInfo.OperatorQueryScopeInfo operatorInfo = (QueryScopeInfo.OperatorQueryScopeInfo)info;
                    JobMetricStore job = this.jobs.computeIfAbsent(operatorInfo.jobID, k -> new JobMetricStore());
                    TaskMetricStore task = job.tasks.computeIfAbsent(operatorInfo.vertexID, k -> new TaskMetricStore());
                    SubtaskMetricStore subtask = task.subtasks.computeIfAbsent(operatorInfo.subtaskIndex, k -> new SubtaskMetricStore());
                    boolean isRepresentativeAttempt = this.isRepresentativeAttempt(operatorInfo.jobID, operatorInfo.vertexID, operatorInfo.subtaskIndex, operatorInfo.attemptNumber);
                    ComponentMetricStore attempt = subtask.attempts.computeIfAbsent(operatorInfo.attemptNumber, k -> new ComponentMetricStore());
                    this.addMetric(attempt, operatorInfo.operatorName + "." + name, metric);
                    if (isRepresentativeAttempt) {
                        this.addMetric(subtask, operatorInfo.operatorName + "." + name, metric);
                        this.addMetric(task, operatorInfo.subtaskIndex + "." + operatorInfo.operatorName + "." + name, metric);
                    }
                    break;
                }
                case 5: {
                    QueryScopeInfo.JobManagerOperatorQueryScopeInfo jmOperatorInfo = (QueryScopeInfo.JobManagerOperatorQueryScopeInfo)info;
                    JobMetricStore job = this.jobs.computeIfAbsent(jmOperatorInfo.jobID, k -> new JobMetricStore());
                    TaskMetricStore task = job.tasks.computeIfAbsent(jmOperatorInfo.vertexID, k -> new TaskMetricStore());
                    ComponentMetricStore jmOperator = task.jmOperator == null ? new ComponentMetricStore() : task.jmOperator;
                    this.addMetric(jmOperator, jmOperatorInfo.operatorName + "." + name, metric);
                    break;
                }
                default: {
                    LOG.debug("Invalid metric dump category: " + info.getCategory());
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Malformed metric dump.", (Throwable)e);
        }
    }

    private boolean isRepresentativeAttempt(String jobID, String vertexID, int subtaskIndex, int attemptNumber) {
        return Optional.of(this.representativeAttempts).map(m -> (Map)m.get(jobID)).map(m -> (Map)m.get(vertexID)).map(m -> (Integer)m.get(subtaskIndex)).orElse(attemptNumber) == attemptNumber;
    }

    private void addMetric(ComponentMetricStore target, String name, MetricDump metric) {
        switch (metric.getCategory()) {
            case 0: {
                MetricDump.CounterDump counter = (MetricDump.CounterDump)metric;
                target.addMetric(name, String.valueOf(counter.count));
                break;
            }
            case 1: {
                MetricDump.GaugeDump gauge = (MetricDump.GaugeDump)metric;
                target.addMetric(name, gauge.value);
                break;
            }
            case 2: {
                MetricDump.HistogramDump histogram = (MetricDump.HistogramDump)metric;
                target.addMetric(name + "_min", String.valueOf(histogram.min));
                target.addMetric(name + "_max", String.valueOf(histogram.max));
                target.addMetric(name + "_mean", String.valueOf(histogram.mean));
                target.addMetric(name + "_median", String.valueOf(histogram.median));
                target.addMetric(name + "_stddev", String.valueOf(histogram.stddev));
                target.addMetric(name + "_p75", String.valueOf(histogram.p75));
                target.addMetric(name + "_p90", String.valueOf(histogram.p90));
                target.addMetric(name + "_p95", String.valueOf(histogram.p95));
                target.addMetric(name + "_p98", String.valueOf(histogram.p98));
                target.addMetric(name + "_p99", String.valueOf(histogram.p99));
                target.addMetric(name + "_p999", String.valueOf(histogram.p999));
                break;
            }
            case 3: {
                MetricDump.MeterDump meter = (MetricDump.MeterDump)metric;
                target.addMetric(name, String.valueOf(meter.rate));
            }
        }
    }

    @ThreadSafe
    public static class SubtaskMetricStore
    extends ComponentMetricStore {
        private final Map<Integer, ComponentMetricStore> attempts;

        private SubtaskMetricStore() {
            this(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<Integer, ComponentMetricStore>());
        }

        private SubtaskMetricStore(Map<String, String> metrics, Map<Integer, ComponentMetricStore> attempts) {
            super(metrics);
            this.attempts = (Map)Preconditions.checkNotNull(attempts);
        }

        public ComponentMetricStore getAttemptsMetricStore(int attemptNumber) {
            return this.attempts.get(attemptNumber);
        }

        public Map<Integer, ComponentMetricStore> getAllAttemptsMetricStores() {
            return Collections.unmodifiableMap(this.attempts);
        }

        void retainAttempts(Set<Integer> currentAttempts) {
            int latestAttempt = currentAttempts.stream().mapToInt(i -> i).max().orElse(0);
            this.attempts.keySet().removeIf(attempt -> attempt < latestAttempt && !currentAttempts.contains(attempt));
        }

        void removeTransientMetrics() {
            this.attempts.values().forEach(attempt -> attempt.removeTransientMetrics(attempt.transientMetrics));
            this.removeTransientMetrics(this.transientMetrics);
        }

        private static SubtaskMetricStore unmodifiable(SubtaskMetricStore source) {
            if (source == null) {
                return null;
            }
            return new SubtaskMetricStore(Collections.unmodifiableMap(source.metrics), Collections.unmodifiableMap(source.attempts));
        }
    }

    @ThreadSafe
    public static class TaskMetricStore
    extends ComponentMetricStore {
        private final Map<Integer, SubtaskMetricStore> subtasks;
        private final ComponentMetricStore jmOperator;

        private TaskMetricStore() {
            this(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<Integer, SubtaskMetricStore>(), new ComponentMetricStore());
        }

        private TaskMetricStore(Map<String, String> metrics, Map<Integer, SubtaskMetricStore> subtasks, ComponentMetricStore jmOperator) {
            super(metrics);
            this.subtasks = (Map)Preconditions.checkNotNull(subtasks);
            this.jmOperator = (ComponentMetricStore)Preconditions.checkNotNull((Object)jmOperator);
        }

        public SubtaskMetricStore getSubtaskMetricStore(int subtaskIndex) {
            return this.subtasks.get(subtaskIndex);
        }

        public Map<Integer, SubtaskMetricStore> getAllSubtaskMetricStores() {
            return Collections.unmodifiableMap(this.subtasks);
        }

        @Override
        boolean isTransientMetric(String name) {
            return name.matches("^\\d+\\..*") && super.isTransientMetric(name);
        }

        void retainSubtasks(Set<Integer> activeSubtasks) {
            this.metrics.keySet().removeIf(key -> {
                String index = key.substring(0, Math.max(key.indexOf(46), 0));
                return index.matches("\\d+") && !activeSubtasks.contains(Integer.parseInt(index));
            });
            this.subtasks.keySet().retainAll(activeSubtasks);
        }

        void removeTransientMetrics(int subtaskIndex) {
            if (this.subtasks.containsKey(subtaskIndex)) {
                Set<String> metricsToRemove = this.transientMetrics.stream().filter(k -> k.startsWith(subtaskIndex + ".")).collect(Collectors.toSet());
                this.removeTransientMetrics(metricsToRemove);
                this.subtasks.get(subtaskIndex).removeTransientMetrics();
            }
        }

        public ComponentMetricStore getJobManagerOperatorMetricStore() {
            return this.jmOperator;
        }

        private static TaskMetricStore unmodifiable(TaskMetricStore source) {
            if (source == null) {
                return null;
            }
            return new TaskMetricStore(Collections.unmodifiableMap(source.metrics), Collections.unmodifiableMap(source.subtasks), ComponentMetricStore.unmodifiable(source.jmOperator));
        }
    }

    @ThreadSafe
    private static class JobMetricStore
    extends ComponentMetricStore {
        private final Map<String, TaskMetricStore> tasks = new ConcurrentHashMap<String, TaskMetricStore>();

        private JobMetricStore() {
        }

        public TaskMetricStore getTaskMetricStore(String taskID) {
            return taskID == null ? null : this.tasks.get(taskID);
        }
    }

    @ThreadSafe
    public static class TaskManagerMetricStore
    extends ComponentMetricStore {
        public final Set<String> garbageCollectorNames;

        private TaskManagerMetricStore() {
            this(new ConcurrentHashMap<String, String>(), ConcurrentHashMap.newKeySet());
        }

        private TaskManagerMetricStore(Map<String, String> metrics, Set<String> garbageCollectorNames) {
            super(metrics);
            this.garbageCollectorNames = (Set)Preconditions.checkNotNull(garbageCollectorNames);
        }

        private void addGarbageCollectorName(String name) {
            this.garbageCollectorNames.add(name);
        }

        private static TaskManagerMetricStore unmodifiable(TaskManagerMetricStore source) {
            if (source == null) {
                return null;
            }
            return new TaskManagerMetricStore(Collections.unmodifiableMap(source.metrics), Collections.unmodifiableSet(source.garbageCollectorNames));
        }
    }

    @ThreadSafe
    public static class ComponentMetricStore {
        public final Map<String, String> metrics;
        public final Set<String> transientMetrics;

        private ComponentMetricStore() {
            this(new ConcurrentHashMap<String, String>());
        }

        private ComponentMetricStore(Map<String, String> metrics) {
            this.metrics = (Map)Preconditions.checkNotNull(metrics);
            this.transientMetrics = ConcurrentHashMap.newKeySet();
        }

        public String getMetric(String name) {
            return this.metrics.get(name);
        }

        public String getMetric(String name, String defaultValue) {
            String value = this.metrics.get(name);
            return value != null ? value : defaultValue;
        }

        private static ComponentMetricStore unmodifiable(ComponentMetricStore source) {
            if (source == null) {
                return null;
            }
            return new ComponentMetricStore(Collections.unmodifiableMap(source.metrics));
        }

        void addMetric(String name, String value) {
            this.metrics.put(name, value);
            if (this.isTransientMetric(name)) {
                this.transientMetrics.add(name);
            }
        }

        boolean isTransientMetric(String name) {
            String metricName = name.substring(name.lastIndexOf(46) + 1);
            return TRANSIENT_METRIC_NAMES.contains(metricName);
        }

        void removeTransientMetrics(Set<String> metricsToRemove) {
            metricsToRemove.stream().filter(this.metrics::containsKey).forEach(key -> {
                this.metrics.remove(key);
                this.transientMetrics.remove(key);
            });
        }
    }
}

