/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.common;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferCompressor;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.disk.DiskTierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.memory.MemoryTierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteTierFactory;
import org.apache.flink.util.Preconditions;

public class TieredStorageUtils {
    private static final float DEFAULT_NUM_BUFFERS_TRIGGER_FLUSH_RATIO = 0.6f;
    private static final int DEFAULT_NUM_BUFFERS_USE_SORT_ACCUMULATOR_THRESHOLD = 512;
    private static final int DEFAULT_MIN_BUFFERS_PER_GATE = 2;
    private static final int DEFAULT_MIN_BUFFERS_PER_RESULT_PARTITION = 8;
    private static final long DEFAULT_POOL_SIZE_CHECK_INTERVAL = 1000L;

    public static float getNumBuffersTriggerFlushRatio() {
        return 0.6f;
    }

    public static int getAccumulatorExclusiveBuffers() {
        return 512;
    }

    public static long getPoolSizeCheckInterval() {
        return 1000L;
    }

    public static int getMinBuffersPerGate() {
        return 2;
    }

    public static int getMinBuffersPerResultPartition() {
        return 8;
    }

    public static String getMemoryTierName() {
        return MemoryTierFactory.class.getSimpleName();
    }

    public static String getDiskTierName() {
        return DiskTierFactory.class.getSimpleName();
    }

    public static String getRemoteTierName() {
        return RemoteTierFactory.class.getSimpleName();
    }

    public static ByteBuffer[] generateBufferWithHeaders(List<Tuple2<Buffer, Integer>> bufferWithIndexes) {
        ByteBuffer[] bufferWithHeaders = new ByteBuffer[2 * bufferWithIndexes.size()];
        for (int i = 0; i < bufferWithIndexes.size(); ++i) {
            Buffer buffer = (Buffer)bufferWithIndexes.get((int)i).f0;
            TieredStorageUtils.setBufferWithHeader(buffer, bufferWithHeaders, 2 * i);
        }
        return bufferWithHeaders;
    }

    private static void setBufferWithHeader(Buffer buffer, ByteBuffer[] bufferWithHeaders, int index) {
        ByteBuffer header = BufferReaderWriterUtil.allocatedHeaderBuffer();
        BufferReaderWriterUtil.setByteChannelBufferHeader(buffer, header);
        bufferWithHeaders[index] = header;
        bufferWithHeaders[index + 1] = buffer.getNioBufferReadable();
    }

    public static Buffer compressBufferIfPossible(Buffer buffer, BufferCompressor bufferCompressor) {
        if (!TieredStorageUtils.canBeCompressed(buffer, bufferCompressor)) {
            return buffer;
        }
        return ((BufferCompressor)Preconditions.checkNotNull((Object)bufferCompressor)).compressToOriginalBuffer(buffer);
    }

    public static boolean canBeCompressed(Buffer buffer, BufferCompressor bufferCompressor) {
        return bufferCompressor != null && buffer.isBuffer() && buffer.readableBytes() > 0;
    }
}

