/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.entrypoint.ModifiableClusterConfiguration;
import org.apache.flink.runtime.entrypoint.parser.CommandLineOptions;
import org.apache.flink.runtime.entrypoint.parser.ConfigurationCommandLineOptions;
import org.apache.flink.runtime.entrypoint.parser.ParserResultFactory;

public class ModifiableClusterConfigurationParserFactory
implements ParserResultFactory<ModifiableClusterConfiguration> {
    public static Options options() {
        Options options = new Options();
        options.addOption(CommandLineOptions.CONFIG_DIR_OPTION);
        options.addOption(ConfigurationCommandLineOptions.REMOVE_KEY_OPTION);
        options.addOption(ConfigurationCommandLineOptions.REMOVE_KEY_VALUE_OPTION);
        options.addOption(ConfigurationCommandLineOptions.REPLACE_KEY_VALUE_OPTION);
        options.addOption(CommandLineOptions.DYNAMIC_PROPERTY_OPTION);
        options.addOption(ConfigurationCommandLineOptions.FLATTEN_CONFIG_OPTION);
        return options;
    }

    @Override
    public Options getOptions() {
        return ModifiableClusterConfigurationParserFactory.options();
    }

    @Override
    public ModifiableClusterConfiguration createResult(@Nonnull CommandLine commandLine) {
        String configDir = commandLine.getOptionValue(CommandLineOptions.CONFIG_DIR_OPTION.getOpt());
        Properties dynamicProperties = commandLine.getOptionProperties(CommandLineOptions.DYNAMIC_PROPERTY_OPTION.getOpt());
        ArrayList<String> removeKeyList = new ArrayList();
        String[] removeKeys = commandLine.getOptionValues(ConfigurationCommandLineOptions.REMOVE_KEY_OPTION.getOpt());
        if (removeKeys != null) {
            removeKeyList = Arrays.asList(removeKeys);
        }
        Properties removeKeyValues = commandLine.getOptionProperties(ConfigurationCommandLineOptions.REMOVE_KEY_VALUE_OPTION.getOpt());
        ArrayList<Tuple3<String, String, String>> replaceKeyValueList = new ArrayList<Tuple3<String, String, String>>();
        String[] replaceKeyValues = commandLine.getOptionValues(ConfigurationCommandLineOptions.REPLACE_KEY_VALUE_OPTION.getOpt());
        if (replaceKeyValues != null) {
            for (int i = 0; i < replaceKeyValues.length; i += 3) {
                replaceKeyValueList.add((Tuple3<String, String, String>)new Tuple3((Object)replaceKeyValues[i], (Object)replaceKeyValues[i + 1], (Object)replaceKeyValues[i + 2]));
            }
        }
        return new ModifiableClusterConfiguration(commandLine.hasOption(ConfigurationCommandLineOptions.FLATTEN_CONFIG_OPTION), configDir, dynamicProperties, removeKeyValues, removeKeyList, replaceKeyValueList);
    }
}

