/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.server;

import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.queryablestate.messages.KvStateInternalRequest;
import org.apache.flink.queryablestate.messages.KvStateResponse;
import org.apache.flink.queryablestate.network.AbstractServerBase;
import org.apache.flink.queryablestate.network.AbstractServerHandler;
import org.apache.flink.queryablestate.network.messages.MessageDeserializer;
import org.apache.flink.queryablestate.network.messages.MessageSerializer;
import org.apache.flink.queryablestate.network.stats.KvStateRequestStats;
import org.apache.flink.queryablestate.server.KvStateServerHandler;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.query.KvStateServer;
import org.apache.flink.util.Preconditions;

@Internal
public class KvStateServerImpl
extends AbstractServerBase<KvStateInternalRequest, KvStateResponse>
implements KvStateServer {
    private final KvStateRegistry kvStateRegistry;
    private final KvStateRequestStats stats;
    private MessageSerializer<KvStateInternalRequest, KvStateResponse> serializer;

    public KvStateServerImpl(String bindAddress, Iterator<Integer> bindPortIterator, Integer numEventLoopThreads, Integer numQueryThreads, KvStateRegistry kvStateRegistry, KvStateRequestStats stats) {
        super("Queryable State Server", bindAddress, bindPortIterator, numEventLoopThreads, numQueryThreads);
        this.stats = (KvStateRequestStats)Preconditions.checkNotNull((Object)stats);
        this.kvStateRegistry = (KvStateRegistry)Preconditions.checkNotNull((Object)kvStateRegistry);
    }

    public AbstractServerHandler<KvStateInternalRequest, KvStateResponse> initializeHandler() {
        this.serializer = new MessageSerializer((MessageDeserializer)new KvStateInternalRequest.KvStateInternalRequestDeserializer(), (MessageDeserializer)new KvStateResponse.KvStateResponseDeserializer());
        return new KvStateServerHandler(this, this.kvStateRegistry, this.serializer, this.stats);
    }

    public MessageSerializer<KvStateInternalRequest, KvStateResponse> getSerializer() {
        Preconditions.checkState((this.serializer != null ? 1 : 0) != 0, (Object)("Server " + this.getServerName() + " has not been started."));
        return this.serializer;
    }

    public void start() throws Throwable {
        super.start();
    }

    public InetSocketAddress getServerAddress() {
        return super.getServerAddress();
    }

    public void shutdown() {
        try {
            this.shutdownServer().get(10L, TimeUnit.SECONDS);
            this.log.info("{} was shutdown successfully.", (Object)this.getServerName());
        }
        catch (Exception e) {
            this.log.warn("{} shutdown failed: {}", (Object)this.getServerName(), (Object)e);
        }
    }
}

