/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.traversals;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.common.Plan;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.dag.TempMode;
import org.apache.flink.optimizer.plan.BinaryUnionPlanNode;
import org.apache.flink.optimizer.plan.BulkIterationPlanNode;
import org.apache.flink.optimizer.plan.BulkPartialSolutionPlanNode;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.IterationPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.plan.SolutionSetPlanNode;
import org.apache.flink.optimizer.plan.SourcePlanNode;
import org.apache.flink.optimizer.plan.WorksetIterationPlanNode;
import org.apache.flink.optimizer.plan.WorksetPlanNode;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.util.Visitor;

public class PlanFinalizer
implements Visitor<PlanNode> {
    private final Set<PlanNode> allNodes = new HashSet<PlanNode>();
    private final List<SourcePlanNode> sources = new ArrayList<SourcePlanNode>();
    private final List<SinkPlanNode> sinks = new ArrayList<SinkPlanNode>();
    private final Deque<IterationPlanNode> stackOfIterationNodes = new ArrayDeque<IterationPlanNode>();
    private int memoryConsumerWeights;

    public OptimizedPlan createFinalPlan(List<SinkPlanNode> sinks, String jobName, Plan originalPlan) {
        this.memoryConsumerWeights = 0;
        for (SinkPlanNode sinkPlanNode : sinks) {
            sinkPlanNode.accept(this);
        }
        if (this.memoryConsumerWeights > 0) {
            for (PlanNode planNode : this.allNodes) {
                int consumerWeight = planNode.getMemoryConsumerWeight();
                if (consumerWeight > 0) {
                    double relativeMem = (double)consumerWeight / (double)this.memoryConsumerWeights;
                    planNode.setRelativeMemoryPerSubtask(relativeMem);
                    if (Optimizer.LOG.isDebugEnabled()) {
                        Optimizer.LOG.debug("Assigned " + relativeMem + " of total memory to each subtask of " + planNode.getProgramOperator().getName() + ".");
                    }
                }
                for (Channel c : planNode.getInputs()) {
                    double relativeMem;
                    if (c.getLocalStrategy().dams()) {
                        relativeMem = 1.0 / (double)this.memoryConsumerWeights;
                        c.setRelativeMemoryLocalStrategy(relativeMem);
                        if (Optimizer.LOG.isDebugEnabled()) {
                            Optimizer.LOG.debug("Assigned " + relativeMem + " of total memory to each local strategy " + "instance of " + c + ".");
                        }
                    }
                    if (c.getTempMode() == TempMode.NONE) continue;
                    relativeMem = 1.0 / (double)this.memoryConsumerWeights;
                    c.setRelativeTempMemory(relativeMem);
                    if (!Optimizer.LOG.isDebugEnabled()) continue;
                    Optimizer.LOG.debug("Assigned " + relativeMem + " of total memory to each instance of the temp " + "table for " + c + ".");
                }
            }
        }
        return new OptimizedPlan(this.sources, this.sinks, this.allNodes, jobName, originalPlan);
    }

    public boolean preVisit(PlanNode visitable) {
        if (!this.allNodes.add(visitable)) {
            return false;
        }
        if (visitable instanceof SinkPlanNode) {
            this.sinks.add((SinkPlanNode)visitable);
        } else if (visitable instanceof SourcePlanNode) {
            this.sources.add((SourcePlanNode)visitable);
        } else if (visitable instanceof BinaryUnionPlanNode) {
            BinaryUnionPlanNode unionNode = (BinaryUnionPlanNode)visitable;
            if (unionNode.unionsStaticAndDynamicPath()) {
                unionNode.setDriverStrategy(DriverStrategy.UNION_WITH_CACHED);
            }
        } else if (visitable instanceof BulkPartialSolutionPlanNode) {
            BulkPartialSolutionPlanNode pspn = (BulkPartialSolutionPlanNode)visitable;
            IterationPlanNode iterationPlanNode = this.stackOfIterationNodes.peekLast();
            if (iterationPlanNode == null || !(iterationPlanNode instanceof BulkIterationPlanNode)) {
                throw new CompilerException("Bug: Error finalizing the plan. Cannot associate the node for a partial solutions with its containing iteration.");
            }
            pspn.setContainingIterationNode((BulkIterationPlanNode)iterationPlanNode);
        } else if (visitable instanceof WorksetPlanNode) {
            WorksetPlanNode wspn = (WorksetPlanNode)visitable;
            IterationPlanNode iterationPlanNode = this.stackOfIterationNodes.peekLast();
            if (iterationPlanNode == null || !(iterationPlanNode instanceof WorksetIterationPlanNode)) {
                throw new CompilerException("Bug: Error finalizing the plan. Cannot associate the node for a partial solutions with its containing iteration.");
            }
            wspn.setContainingIterationNode((WorksetIterationPlanNode)iterationPlanNode);
        } else if (visitable instanceof SolutionSetPlanNode) {
            SolutionSetPlanNode sspn = (SolutionSetPlanNode)visitable;
            IterationPlanNode iterationPlanNode = this.stackOfIterationNodes.peekLast();
            if (iterationPlanNode == null || !(iterationPlanNode instanceof WorksetIterationPlanNode)) {
                throw new CompilerException("Bug: Error finalizing the plan. Cannot associate the node for a partial solutions with its containing iteration.");
            }
            sspn.setContainingIterationNode((WorksetIterationPlanNode)iterationPlanNode);
        }
        for (Channel channel : visitable.getInputs()) {
            channel.setTarget(visitable);
            channel.getSource().addOutgoingChannel(channel);
        }
        for (Channel channel : visitable.getBroadcastInputs()) {
            channel.setTarget(visitable);
            channel.getSource().addOutgoingChannel(channel);
        }
        this.memoryConsumerWeights += visitable.getMemoryConsumerWeight();
        for (Channel channel : visitable.getInputs()) {
            if (channel.getLocalStrategy().dams()) {
                ++this.memoryConsumerWeights;
            }
            if (channel.getTempMode() == TempMode.NONE) continue;
            ++this.memoryConsumerWeights;
        }
        for (Channel channel : visitable.getBroadcastInputs()) {
            if (channel.getLocalStrategy().dams()) {
                ++this.memoryConsumerWeights;
            }
            if (channel.getTempMode() == TempMode.NONE) continue;
            ++this.memoryConsumerWeights;
        }
        if (visitable instanceof IterationPlanNode) {
            IterationPlanNode iterNode = (IterationPlanNode)((Object)visitable);
            this.stackOfIterationNodes.addLast(iterNode);
            ((IterationPlanNode)((Object)visitable)).acceptForStepFunction(this);
            this.stackOfIterationNodes.removeLast();
        }
        return true;
    }

    public void postVisit(PlanNode visitable) {
    }
}

