/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.operators;

import java.util.List;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.dag.TwoInputNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.optimizer.operators.AbstractOperatorDescriptor;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.DualInputPlanNode;

public abstract class OperatorDescriptorDual
implements AbstractOperatorDescriptor {
    protected final FieldList keys1;
    protected final FieldList keys2;
    private List<GlobalPropertiesPair> globalProps;
    private List<LocalPropertiesPair> localProps;

    protected OperatorDescriptorDual() {
        this(null, null);
    }

    protected OperatorDescriptorDual(FieldList keys1, FieldList keys2) {
        this.keys1 = keys1;
        this.keys2 = keys2;
    }

    public List<GlobalPropertiesPair> getPossibleGlobalProperties() {
        if (this.globalProps == null) {
            this.globalProps = this.createPossibleGlobalProperties();
        }
        return this.globalProps;
    }

    public List<LocalPropertiesPair> getPossibleLocalProperties() {
        if (this.localProps == null) {
            this.localProps = this.createPossibleLocalProperties();
        }
        return this.localProps;
    }

    protected abstract List<GlobalPropertiesPair> createPossibleGlobalProperties();

    protected abstract List<LocalPropertiesPair> createPossibleLocalProperties();

    public abstract boolean areCompatible(RequestedGlobalProperties var1, RequestedGlobalProperties var2, GlobalProperties var3, GlobalProperties var4);

    public abstract boolean areCoFulfilled(RequestedLocalProperties var1, RequestedLocalProperties var2, LocalProperties var3, LocalProperties var4);

    public abstract DualInputPlanNode instantiate(Channel var1, Channel var2, TwoInputNode var3);

    public abstract GlobalProperties computeGlobalProperties(GlobalProperties var1, GlobalProperties var2);

    public abstract LocalProperties computeLocalProperties(LocalProperties var1, LocalProperties var2);

    protected boolean checkEquivalentFieldPositionsInKeyFields(FieldList fields1, FieldList fields2) {
        if (fields1.size() != fields2.size()) {
            return false;
        }
        return this.checkEquivalentFieldPositionsInKeyFields(fields1, fields2, fields1.size());
    }

    protected boolean checkEquivalentFieldPositionsInKeyFields(FieldList fields1, FieldList fields2, int numRelevantFields) {
        if (fields1.size() < numRelevantFields || fields2.size() < numRelevantFields) {
            return false;
        }
        for (int i = 0; i < numRelevantFields; ++i) {
            int j;
            int pField1 = fields1.get(i);
            int pField2 = fields2.get(i);
            for (j = 0; j < this.keys1.size() && (this.keys1.get(j) != pField1 || this.keys2.get(j) != pField2); ++j) {
                if (this.keys1.get(j) != pField1 && this.keys2.get(j) != pField2) continue;
                return false;
            }
            if (j != this.keys1.size()) continue;
            throw new CompilerException("Fields were not found in key fields.");
        }
        return true;
    }

    protected boolean checkSameOrdering(LocalProperties produced1, LocalProperties produced2, int numRelevantFields) {
        Ordering prod1 = produced1.getOrdering();
        Ordering prod2 = produced2.getOrdering();
        if (prod1 == null || prod2 == null) {
            throw new CompilerException("The given properties do not meet this operators requirements.");
        }
        if (!this.checkEquivalentFieldPositionsInKeyFields(prod1.getInvolvedIndexes(), prod2.getInvolvedIndexes(), numRelevantFields)) {
            return false;
        }
        for (int i = 0; i < numRelevantFields; ++i) {
            if (prod1.getOrder(i) == prod2.getOrder(i)) continue;
            return false;
        }
        return true;
    }

    public static final class LocalPropertiesPair {
        private final RequestedLocalProperties props1;
        private final RequestedLocalProperties props2;

        public LocalPropertiesPair(RequestedLocalProperties props1, RequestedLocalProperties props2) {
            this.props1 = props1;
            this.props2 = props2;
        }

        public RequestedLocalProperties getProperties1() {
            return this.props1;
        }

        public RequestedLocalProperties getProperties2() {
            return this.props2;
        }

        public int hashCode() {
            return (this.props1 == null ? 0 : this.props1.hashCode()) ^ (this.props2 == null ? 0 : this.props2.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == LocalPropertiesPair.class) {
                LocalPropertiesPair other = (LocalPropertiesPair)obj;
                return (this.props1 == null ? other.props1 == null : this.props1.equals(other.props1)) && (this.props2 == null ? other.props2 == null : this.props2.equals(other.props2));
            }
            return false;
        }

        public String toString() {
            return "{" + this.props1 + " / " + this.props2 + "}";
        }
    }

    public static final class GlobalPropertiesPair {
        private final RequestedGlobalProperties props1;
        private final RequestedGlobalProperties props2;

        public GlobalPropertiesPair(RequestedGlobalProperties props1, RequestedGlobalProperties props2) {
            this.props1 = props1;
            this.props2 = props2;
        }

        public RequestedGlobalProperties getProperties1() {
            return this.props1;
        }

        public RequestedGlobalProperties getProperties2() {
            return this.props2;
        }

        public int hashCode() {
            return (this.props1 == null ? 0 : this.props1.hashCode()) ^ (this.props2 == null ? 0 : this.props2.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == GlobalPropertiesPair.class) {
                GlobalPropertiesPair other = (GlobalPropertiesPair)obj;
                return (this.props1 == null ? other.props1 == null : this.props1.equals(other.props1)) && (this.props2 == null ? other.props2 == null : this.props2.equals(other.props2));
            }
            return false;
        }

        public String toString() {
            return "{" + this.props1 + " / " + this.props2 + "}";
        }
    }
}

