/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.base.BulkIterationBase;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.dag.BinaryUnionNode;
import org.apache.flink.optimizer.dag.BulkPartialSolutionNode;
import org.apache.flink.optimizer.dag.DagConnection;
import org.apache.flink.optimizer.dag.InterestingPropertiesClearer;
import org.apache.flink.optimizer.dag.IterationNode;
import org.apache.flink.optimizer.dag.NoOpNode;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dag.PlanCacheCleaner;
import org.apache.flink.optimizer.dag.SingleInputNode;
import org.apache.flink.optimizer.dag.UnaryOperatorNode;
import org.apache.flink.optimizer.dag.WorksetIterationNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.InterestingProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.optimizer.operators.NoOpDescriptor;
import org.apache.flink.optimizer.operators.OperatorDescriptorSingle;
import org.apache.flink.optimizer.plan.BulkIterationPlanNode;
import org.apache.flink.optimizer.plan.BulkPartialSolutionPlanNode;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.NamedChannel;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.traversals.InterestingPropertyVisitor;
import org.apache.flink.optimizer.util.NoOpUnaryUdfOp;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.util.Visitor;

public class BulkIterationNode
extends SingleInputNode
implements IterationNode {
    private BulkPartialSolutionNode partialSolution;
    private OptimizerNode terminationCriterion;
    private OptimizerNode nextPartialSolution;
    private DagConnection rootConnection;
    private DagConnection terminationCriterionRootConnection;
    private OptimizerNode singleRoot;
    private final int costWeight;

    public BulkIterationNode(BulkIterationBase<?> iteration) {
        super((SingleInputOperator<?, ?, ?>)iteration);
        if (iteration.getMaximumNumberOfIterations() <= 0) {
            throw new CompilerException("BulkIteration must have a maximum number of iterations specified.");
        }
        int numIters = iteration.getMaximumNumberOfIterations();
        this.costWeight = numIters > 0 && numIters < 100 ? numIters : 100;
    }

    public BulkIterationBase<?> getIterationContract() {
        return (BulkIterationBase)this.getOperator();
    }

    public BulkPartialSolutionNode getPartialSolution() {
        return this.partialSolution;
    }

    public void setPartialSolution(BulkPartialSolutionNode partialSolution) {
        this.partialSolution = partialSolution;
    }

    public OptimizerNode getNextPartialSolution() {
        return this.nextPartialSolution;
    }

    public void setNextPartialSolution(OptimizerNode nextPartialSolution, OptimizerNode terminationCriterion) {
        if (nextPartialSolution.getParallelism() != this.getParallelism() || nextPartialSolution == this.partialSolution || nextPartialSolution instanceof BinaryUnionNode) {
            NoOpNode noop = new NoOpNode();
            noop.setParallelism(this.getParallelism());
            DagConnection noOpConn = new DagConnection(nextPartialSolution, noop, ExecutionMode.PIPELINED);
            noop.setIncomingConnection(noOpConn);
            nextPartialSolution.addOutgoingConnection(noOpConn);
            nextPartialSolution = noop;
        }
        this.nextPartialSolution = nextPartialSolution;
        this.terminationCriterion = terminationCriterion;
        if (terminationCriterion == null) {
            this.singleRoot = nextPartialSolution;
            this.rootConnection = new DagConnection(nextPartialSolution, ExecutionMode.PIPELINED);
        } else {
            WorksetIterationNode.SingleRootJoiner singleRootJoiner = new WorksetIterationNode.SingleRootJoiner();
            this.rootConnection = new DagConnection(nextPartialSolution, singleRootJoiner, ExecutionMode.PIPELINED);
            this.terminationCriterionRootConnection = new DagConnection(terminationCriterion, singleRootJoiner, ExecutionMode.PIPELINED);
            singleRootJoiner.setInputs(this.rootConnection, this.terminationCriterionRootConnection);
            this.singleRoot = singleRootJoiner;
            terminationCriterion.addOutgoingConnection(this.terminationCriterionRootConnection);
        }
        nextPartialSolution.addOutgoingConnection(this.rootConnection);
    }

    @Override
    public int getCostWeight() {
        return this.costWeight;
    }

    public OptimizerNode getSingleRootOfStepFunction() {
        return this.singleRoot;
    }

    @Override
    public String getOperatorName() {
        return "Bulk Iteration";
    }

    @Override
    public SemanticProperties getSemanticProperties() {
        return new SemanticProperties.EmptySemanticProperties();
    }

    @Override
    protected void readStubAnnotations() {
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        this.estimatedOutputSize = this.getPredecessorNode().getEstimatedOutputSize();
        this.estimatedNumRecords = this.getPredecessorNode().getEstimatedNumRecords();
    }

    @Override
    protected List<OperatorDescriptorSingle> getPossibleProperties() {
        return Collections.singletonList(new NoOpDescriptor());
    }

    @Override
    public void computeInterestingPropertiesForInputs(CostEstimator estimator) {
        InterestingProperties intProps = this.getInterestingProperties().clone();
        if (this.terminationCriterion != null) {
            this.terminationCriterionRootConnection.setInterestingProperties(new InterestingProperties());
            this.terminationCriterion.accept(new InterestingPropertyVisitor(estimator));
        }
        this.rootConnection.setInterestingProperties(intProps);
        this.nextPartialSolution.accept(new InterestingPropertyVisitor(estimator));
        InterestingProperties partialSolutionIntProps = this.partialSolution.getInterestingProperties();
        intProps.getGlobalProperties().addAll(partialSolutionIntProps.getGlobalProperties());
        intProps.getLocalProperties().addAll(partialSolutionIntProps.getLocalProperties());
        this.rootConnection.clearInterestingProperties();
        this.nextPartialSolution.accept(InterestingPropertiesClearer.INSTANCE);
        this.rootConnection.setInterestingProperties(intProps);
        this.nextPartialSolution.accept(new InterestingPropertyVisitor(estimator));
        InterestingProperties inProps = this.partialSolution.getInterestingProperties().clone();
        inProps.addGlobalProperties(new RequestedGlobalProperties());
        inProps.addLocalProperties(new RequestedLocalProperties());
        this.inConn.setInterestingProperties(inProps);
    }

    @Override
    public void clearInterestingProperties() {
        super.clearInterestingProperties();
        this.singleRoot.accept(InterestingPropertiesClearer.INSTANCE);
        this.rootConnection.clearInterestingProperties();
    }

    @Override
    public void computeUnclosedBranchStack() {
        if (this.openBranches != null) {
            return;
        }
        this.addClosedBranches(this.getSingleRootOfStepFunction().closedBranchingNodes);
        List<OptimizerNode.UnclosedBranchDescriptor> result = this.getSingleRootOfStepFunction().openBranches;
        this.openBranches = result == null || result.isEmpty() ? Collections.emptyList() : result;
    }

    @Override
    protected void instantiateCandidate(OperatorDescriptorSingle dps, Channel in, List<Set<? extends NamedChannel>> broadcastPlanChannels, List<PlanNode> target, CostEstimator estimator, RequestedGlobalProperties globPropsReq, RequestedLocalProperties locPropsReq) {
        block8: {
            List<PlanNode> candidates;
            BulkPartialSolutionPlanNode pspn;
            block7: {
                this.nextPartialSolution.accept(PlanCacheCleaner.INSTANCE);
                if (this.terminationCriterion != null) {
                    this.terminationCriterion.accept(PlanCacheCleaner.INSTANCE);
                }
                this.partialSolution.setCandidateProperties(in.getGlobalProperties(), in.getLocalProperties(), in);
                pspn = this.partialSolution.getCurrentPartialSolutionPlanNode();
                candidates = this.nextPartialSolution.getAlternativePlans(estimator);
                ArrayList<SingleInputPlanNode> newCandidates = new ArrayList<SingleInputPlanNode>();
                Iterator<PlanNode> planDeleter = candidates.iterator();
                while (planDeleter.hasNext()) {
                    PlanNode.FeedbackPropertiesMeetRequirementsReport report2;
                    LocalProperties atEndLocal;
                    GlobalProperties atEndGlobal;
                    PlanNode candidate = planDeleter.next();
                    PlanNode.FeedbackPropertiesMeetRequirementsReport report = candidate.checkPartialSolutionPropertiesMet(pspn, atEndGlobal = candidate.getGlobalProperties(), atEndLocal = candidate.getLocalProperties());
                    if (report == PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION || report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET) continue;
                    Channel toNoOp = new Channel(candidate);
                    globPropsReq.parameterizeChannel(toNoOp, false, this.rootConnection.getDataExchangeMode(), false);
                    locPropsReq.parameterizeChannel(toNoOp);
                    NoOpUnaryUdfOp noOpUnaryUdfOp = new NoOpUnaryUdfOp();
                    noOpUnaryUdfOp.setInput(candidate.getProgramOperator());
                    UnaryOperatorNode rebuildPropertiesNode = new UnaryOperatorNode("Rebuild Partial Solution Properties", noOpUnaryUdfOp, true);
                    rebuildPropertiesNode.setParallelism(candidate.getParallelism());
                    SingleInputPlanNode rebuildPropertiesPlanNode = new SingleInputPlanNode(rebuildPropertiesNode, "Rebuild Partial Solution Properties", toNoOp, DriverStrategy.UNARY_NO_OP);
                    rebuildPropertiesPlanNode.initProperties(toNoOp.getGlobalProperties(), toNoOp.getLocalProperties());
                    estimator.costOperator(rebuildPropertiesPlanNode);
                    GlobalProperties atEndGlobalModified = rebuildPropertiesPlanNode.getGlobalProperties();
                    LocalProperties atEndLocalModified = rebuildPropertiesPlanNode.getLocalProperties();
                    if (!(atEndGlobalModified.equals(atEndGlobal) && atEndLocalModified.equals(atEndLocal) || (report2 = candidate.checkPartialSolutionPropertiesMet(pspn, atEndGlobalModified, atEndLocalModified)) == PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET)) {
                        newCandidates.add(rebuildPropertiesPlanNode);
                    }
                    planDeleter.remove();
                }
                candidates.addAll(newCandidates);
                if (candidates.isEmpty()) {
                    return;
                }
                if (this.terminationCriterion != null) break block7;
                for (PlanNode candidate : candidates) {
                    BulkIterationPlanNode node = new BulkIterationPlanNode(this, this.getOperator().getName(), in, pspn, candidate);
                    GlobalProperties gProps = candidate.getGlobalProperties().clone();
                    LocalProperties lProps = candidate.getLocalProperties().clone();
                    node.initProperties(gProps, lProps);
                    target.add(node);
                }
                break block8;
            }
            if (candidates.size() <= 0) break block8;
            List<PlanNode> terminationCriterionCandidates = this.terminationCriterion.getAlternativePlans(estimator);
            WorksetIterationNode.SingleRootJoiner singleRoot = (WorksetIterationNode.SingleRootJoiner)this.singleRoot;
            for (PlanNode candidate : candidates) {
                for (PlanNode terminationCandidate : terminationCriterionCandidates) {
                    if (!singleRoot.areBranchCompatible(candidate, terminationCandidate)) continue;
                    BulkIterationPlanNode node = new BulkIterationPlanNode(this, "BulkIteration (" + this.getOperator().getName() + ")", in, pspn, candidate, terminationCandidate);
                    GlobalProperties gProps = candidate.getGlobalProperties().clone();
                    LocalProperties lProps = candidate.getLocalProperties().clone();
                    node.initProperties(gProps, lProps);
                    target.add(node);
                }
            }
        }
    }

    @Override
    public void acceptForStepFunction(Visitor<OptimizerNode> visitor) {
        this.singleRoot.accept(visitor);
    }
}

