/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.migration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import org.apache.flink.FlinkVersion;

public class PublishedVersionUtils {
    private static final String MOST_RECENTLY_PUBLISHED_VERSION_FILE = "most_recently_published_version";

    /*
     * Enabled aggressive exception aggregation
     */
    public static FlinkVersion getMostRecentlyPublishedVersion() {
        try (InputStream input = Objects.requireNonNull(PublishedVersionUtils.class.getResourceAsStream("/most_recently_published_version"), "The most-recently published version file does not exist");){
            FlinkVersion flinkVersion;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
                String versionName = reader.readLine();
                flinkVersion = FlinkVersion.valueOf((String)versionName);
            }
            return flinkVersion;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse the latest published version", e);
        }
    }
}

