/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.status;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.status.CheckpointType;
import org.apache.flink.kubernetes.operator.api.status.Snapshot;
import org.apache.flink.kubernetes.operator.api.status.SnapshotTriggerType;

@Experimental
public class Checkpoint
implements Snapshot {
    private long timeStamp;
    private SnapshotTriggerType triggerType = SnapshotTriggerType.UNKNOWN;
    private CheckpointType formatType = CheckpointType.UNKNOWN;
    private Long triggerNonce;

    public Checkpoint(long timeStamp, @Nullable SnapshotTriggerType triggerType, @Nullable CheckpointType formatType, @Nullable Long triggerNonce) {
        this.timeStamp = timeStamp;
        if (triggerType != null) {
            this.triggerType = triggerType;
        }
        if (formatType != null) {
            this.formatType = formatType;
        }
        this.triggerNonce = triggerNonce;
    }

    public static Checkpoint of(long timeStamp, SnapshotTriggerType triggerType) {
        return new Checkpoint(timeStamp, triggerType, CheckpointType.UNKNOWN, null);
    }

    public static Checkpoint of(SnapshotTriggerType triggerType) {
        return new Checkpoint(System.currentTimeMillis(), triggerType, CheckpointType.UNKNOWN, null);
    }

    public static Checkpoint of(SnapshotTriggerType triggerType, CheckpointType formatType) {
        return new Checkpoint(System.currentTimeMillis(), triggerType, formatType, null);
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public SnapshotTriggerType getTriggerType() {
        return this.triggerType;
    }

    public CheckpointType getFormatType() {
        return this.formatType;
    }

    public Long getTriggerNonce() {
        return this.triggerNonce;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setTriggerType(SnapshotTriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public void setFormatType(CheckpointType formatType) {
        this.formatType = formatType;
    }

    public void setTriggerNonce(Long triggerNonce) {
        this.triggerNonce = triggerNonce;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Checkpoint)) {
            return false;
        }
        Checkpoint other = (Checkpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        Long this$triggerNonce = this.getTriggerNonce();
        Long other$triggerNonce = other.getTriggerNonce();
        if (this$triggerNonce == null ? other$triggerNonce != null : !((Object)this$triggerNonce).equals(other$triggerNonce)) {
            return false;
        }
        SnapshotTriggerType this$triggerType = this.getTriggerType();
        SnapshotTriggerType other$triggerType = other.getTriggerType();
        if (this$triggerType == null ? other$triggerType != null : !((Object)((Object)this$triggerType)).equals((Object)other$triggerType)) {
            return false;
        }
        CheckpointType this$formatType = this.getFormatType();
        CheckpointType other$formatType = other.getFormatType();
        return !(this$formatType == null ? other$formatType != null : !((Object)((Object)this$formatType)).equals((Object)other$formatType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Checkpoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        Long $triggerNonce = this.getTriggerNonce();
        result = result * 59 + ($triggerNonce == null ? 43 : ((Object)$triggerNonce).hashCode());
        SnapshotTriggerType $triggerType = this.getTriggerType();
        result = result * 59 + ($triggerType == null ? 43 : ((Object)((Object)$triggerType)).hashCode());
        CheckpointType $formatType = this.getFormatType();
        result = result * 59 + ($formatType == null ? 43 : ((Object)((Object)$formatType)).hashCode());
        return result;
    }

    public String toString() {
        return "Checkpoint(timeStamp=" + this.getTimeStamp() + ", triggerType=" + this.getTriggerType() + ", formatType=" + this.getFormatType() + ", triggerNonce=" + this.getTriggerNonce() + ")";
    }

    public Checkpoint() {
    }
}

