/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.listener;

import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.time.Instant;
import org.apache.flink.core.plugin.Plugin;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.FlinkStateSnapshot;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.api.status.FlinkSessionJobStatus;
import org.apache.flink.kubernetes.operator.api.status.FlinkStateSnapshotStatus;

public interface FlinkResourceListener
extends Plugin {
    public void onDeploymentStatusUpdate(StatusUpdateContext<FlinkDeployment, FlinkDeploymentStatus> var1);

    public void onDeploymentEvent(ResourceEventContext<FlinkDeployment> var1);

    public void onSessionJobStatusUpdate(StatusUpdateContext<FlinkSessionJob, FlinkSessionJobStatus> var1);

    public void onSessionJobEvent(ResourceEventContext<FlinkSessionJob> var1);

    public void onStateSnapshotEvent(FlinkStateSnapshotEventContext var1);

    public void onStateSnapshotStatusUpdate(FlinkStateSnapshotStatusUpdateContext var1);

    public static interface FlinkStateSnapshotResourceContext
    extends ResourceContext {
        public FlinkStateSnapshot getStateSnapshot();
    }

    public static interface FlinkStateSnapshotEventContext
    extends FlinkStateSnapshotResourceContext {
        public Event getEvent();

        @Override
        default public Instant getTimestamp() {
            return Instant.parse(this.getEvent().getLastTimestamp());
        }
    }

    public static interface FlinkStateSnapshotStatusUpdateContext
    extends FlinkStateSnapshotResourceContext {
        default public FlinkStateSnapshotStatus getNewStatus() {
            return (FlinkStateSnapshotStatus)this.getStateSnapshot().getStatus();
        }

        public FlinkStateSnapshotStatus getPreviousStatus();
    }

    public static interface StatusUpdateContext<R extends AbstractFlinkResource<?, S>, S extends CommonStatus<?>>
    extends FlinkResourceContext<R> {
        default public S getNewStatus() {
            return (S)((CommonStatus)this.getFlinkResource().getStatus());
        }

        public S getPreviousStatus();
    }

    public static interface ResourceEventContext<R extends AbstractFlinkResource<?, ?>>
    extends FlinkResourceContext<R> {
        public Event getEvent();

        @Override
        default public Instant getTimestamp() {
            return Instant.parse(this.getEvent().getLastTimestamp());
        }
    }

    public static interface FlinkResourceContext<R extends AbstractFlinkResource<?, ?>>
    extends ResourceContext {
        public R getFlinkResource();
    }

    public static interface ResourceContext {
        public KubernetesClient getKubernetesClient();

        public Instant getTimestamp();
    }
}

