/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.operators.AbstractUdfOperator;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.BulkIterationBase;
import org.apache.flink.api.common.operators.base.DeltaIterationBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.BulkIterationResultSet;
import org.apache.flink.api.java.operators.DataSink;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.DeltaIterationResultSet;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.NoOpOperator;
import org.apache.flink.api.java.operators.SingleInputOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.operators.TwoInputOperator;
import org.apache.flink.api.java.operators.TwoInputUdfOperator;
import org.apache.flink.api.java.operators.UdfOperator;
import org.apache.flink.api.java.operators.UnionOperator;
import org.apache.flink.configuration.Configuration;

@Internal
public class OperatorTranslation {
    private Map<DataSet<?>, Operator<?>> translated = new HashMap();

    public Plan translateToPlan(List<DataSink<?>> sinks, String jobName) {
        ArrayList planSinks = new ArrayList();
        for (DataSink<?> sink : sinks) {
            planSinks.add(this.translate(sink));
        }
        Plan p = new Plan(planSinks);
        p.setJobName(jobName);
        return p;
    }

    private <T> GenericDataSinkBase<T> translate(DataSink<T> sink) {
        Operator<T> input = this.translate(sink.getDataSet());
        GenericDataSinkBase<T> translatedSink = sink.translateToDataFlow(input);
        return translatedSink;
    }

    private <T> Operator<T> translate(DataSet<T> dataSet) {
        GenericDataSourceBase dataFlowOp;
        while (dataSet instanceof NoOpOperator) {
            dataSet = ((NoOpOperator)dataSet).getInput();
        }
        Operator<?> previous = this.translated.get(dataSet);
        if (previous != null && !(dataSet instanceof UnionOperator)) {
            Operator<?> typedPrevious = previous;
            return typedPrevious;
        }
        if (dataSet instanceof DataSource) {
            dataFlowOp = ((DataSource)dataSet).translateToDataFlow();
        } else if (dataSet instanceof SingleInputOperator) {
            dataFlowOp = this.translateSingleInputOperator((SingleInputOperator)dataSet);
        } else if (dataSet instanceof TwoInputOperator) {
            dataFlowOp = this.translateTwoInputOperator((TwoInputOperator)dataSet);
        } else if (dataSet instanceof BulkIterationResultSet) {
            dataFlowOp = this.translateBulkIteration((BulkIterationResultSet)dataSet);
        } else if (dataSet instanceof DeltaIterationResultSet) {
            dataFlowOp = this.translateDeltaIteration((DeltaIterationResultSet)dataSet);
        } else {
            if (dataSet instanceof DeltaIteration.SolutionSetPlaceHolder || dataSet instanceof DeltaIteration.WorksetPlaceHolder) {
                throw new InvalidProgramException("A data set that is part of a delta iteration was used as a sink or action. Did you forget to close the iteration?");
            }
            throw new RuntimeException("Error while creating the data flow plan for the program: Unknown operator or data set type: " + dataSet);
        }
        this.translated.put(dataSet, (Operator<?>)dataFlowOp);
        this.translateBcVariables(dataSet, (Operator<?>)dataFlowOp);
        return dataFlowOp;
    }

    private <I, O> Operator<O> translateSingleInputOperator(SingleInputOperator<?, ?, ?> op) {
        SingleInputOperator<?, ?, ?> typedOp = op;
        DataSet<?> typedInput = op.getInput();
        Operator<?> input = this.translate(typedInput);
        Operator<?> dataFlowOp = typedOp.translateToDataFlow(input);
        if (op instanceof UdfOperator) {
            SingleInputUdfOperator udfOp = (SingleInputUdfOperator)op;
            Configuration opParams = udfOp.getParameters();
            if (opParams != null) {
                dataFlowOp.getParameters().addAll(opParams);
            }
            if (dataFlowOp instanceof org.apache.flink.api.common.operators.SingleInputOperator) {
                org.apache.flink.api.common.operators.SingleInputOperator unaryOp = (org.apache.flink.api.common.operators.SingleInputOperator)dataFlowOp;
                unaryOp.setSemanticProperties(udfOp.getSemanticProperties());
            }
        }
        return dataFlowOp;
    }

    private <I1, I2, O> Operator<O> translateTwoInputOperator(TwoInputOperator<?, ?, ?, ?> op) {
        TwoInputOperator<?, ?, ?, ?> typedOp = op;
        DataSet<?> typedInput1 = op.getInput1();
        DataSet<?> typedInput2 = op.getInput2();
        Operator<?> input1 = this.translate(typedInput1);
        Operator<?> input2 = this.translate(typedInput2);
        Operator<?> dataFlowOp = typedOp.translateToDataFlow(input1, input2);
        if (op instanceof UdfOperator) {
            TwoInputUdfOperator udfOp = (TwoInputUdfOperator)op;
            Configuration opParams = udfOp.getParameters();
            if (opParams != null) {
                dataFlowOp.getParameters().addAll(opParams);
            }
            if (dataFlowOp instanceof DualInputOperator) {
                DualInputOperator binaryOp = (DualInputOperator)dataFlowOp;
                binaryOp.setSemanticProperties(udfOp.getSemanticProperties());
            }
        }
        return dataFlowOp;
    }

    private <T> BulkIterationBase<T> translateBulkIteration(BulkIterationResultSet<?> untypedIterationEnd) {
        BulkIterationResultSet<?> iterationEnd = untypedIterationEnd;
        BulkIterationBase iterationOperator = new BulkIterationBase(new UnaryOperatorInformation(iterationEnd.getType(), iterationEnd.getType()), "Bulk Iteration");
        IterativeDataSet<?> iterationHead = iterationEnd.getIterationHead();
        this.translated.put(iterationHead, iterationOperator.getPartialSolution());
        Operator<?> translatedBody = this.translate(iterationEnd.getNextPartialSolution());
        iterationOperator.setNextPartialSolution(translatedBody);
        iterationOperator.setMaximumNumberOfIterations(iterationHead.getMaxIterations());
        iterationOperator.setInput(this.translate(iterationHead.getInput()));
        iterationOperator.getAggregators().addAll(iterationHead.getAggregators());
        if (iterationEnd.getTerminationCriterion() != null) {
            iterationOperator.setTerminationCriterion(this.translate(iterationEnd.getTerminationCriterion()));
        }
        return iterationOperator;
    }

    private <D, W> DeltaIterationBase<D, W> translateDeltaIteration(DeltaIterationResultSet<?, ?> untypedIterationEnd) {
        DeltaIterationResultSet<?, ?> iterationEnd = untypedIterationEnd;
        DeltaIteration<?, ?> iterationHead = iterationEnd.getIterationHead();
        String name = iterationHead.getName() == null ? "Unnamed Delta Iteration" : iterationHead.getName();
        DeltaIterationBase iterationOperator = new DeltaIterationBase(new BinaryOperatorInformation(iterationEnd.getType(), iterationEnd.getWorksetType(), iterationEnd.getType()), iterationEnd.getKeyPositions(), name);
        iterationOperator.setMaximumNumberOfIterations(iterationEnd.getMaxIterations());
        if (iterationHead.getParallelism() > 0) {
            iterationOperator.setParallelism(iterationHead.getParallelism());
        }
        DeltaIteration.SolutionSetPlaceHolder<?> solutionSetPlaceHolder = iterationHead.getSolutionSet();
        DeltaIteration.WorksetPlaceHolder<?> worksetPlaceHolder = iterationHead.getWorkset();
        this.translated.put(solutionSetPlaceHolder, iterationOperator.getSolutionSet());
        this.translated.put(worksetPlaceHolder, iterationOperator.getWorkset());
        Operator<?> translatedSolutionSet = this.translate(iterationEnd.getNextSolutionSet());
        Operator<?> translatedWorkset = this.translate(iterationEnd.getNextWorkset());
        iterationOperator.setNextWorkset(translatedWorkset);
        iterationOperator.setSolutionSetDelta(translatedSolutionSet);
        iterationOperator.setInitialSolutionSet(this.translate(iterationHead.getInitialSolutionSet()));
        iterationOperator.setInitialWorkset(this.translate(iterationHead.getInitialWorkset()));
        iterationOperator.getAggregators().addAll(iterationHead.getAggregators());
        iterationOperator.setSolutionSetUnManaged(iterationHead.isSolutionSetUnManaged());
        return iterationOperator;
    }

    private void translateBcVariables(DataSet<?> setOrOp, Operator<?> dataFlowOp) {
        if (setOrOp instanceof UdfOperator) {
            if (!(dataFlowOp instanceof AbstractUdfOperator)) {
                throw new RuntimeException("Error while creating the data flow plan for the program: A UDF operation was not translated to a UDF operator.");
            }
            UdfOperator udfOp = (UdfOperator)((Object)setOrOp);
            AbstractUdfOperator udfDataFlowOp = (AbstractUdfOperator)dataFlowOp;
            for (Map.Entry<String, DataSet<?>> bcVariable : udfOp.getBroadcastSets().entrySet()) {
                Operator<?> bcInput = this.translate(bcVariable.getValue());
                udfDataFlowOp.setBroadcastVariable(bcVariable.getKey(), bcInput);
            }
        }
    }
}

