/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.GenericCsvInputFormat;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@Internal
public abstract class CsvInputFormat<OUT>
extends GenericCsvInputFormat<OUT> {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_LINE_DELIMITER = "\n";
    public static final String DEFAULT_FIELD_DELIMITER = ",";
    protected transient Object[] parsedValues;

    protected CsvInputFormat(Path filePath) {
        super(filePath);
    }

    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        FieldParser[] fieldParsers = this.getFieldParsers();
        if (fieldParsers.length == 0) {
            throw new IOException("CsvInputFormat.open(FileInputSplit split) - no field parsers to parse input");
        }
        this.parsedValues = new Object[fieldParsers.length];
        for (int i = 0; i < fieldParsers.length; ++i) {
            this.parsedValues[i] = fieldParsers[i].createValue();
        }
        if (this.getDelimiter().length == 1 && this.getDelimiter()[0] == 10) {
            this.lineDelimiterIsLinebreak = true;
        }
        this.commentCount = 0;
        this.invalidLineCount = 0;
    }

    public OUT nextRecord(OUT record) throws IOException {
        Object returnRecord = null;
        while ((returnRecord = super.nextRecord(record)) == null && !this.reachedEnd()) {
        }
        return (OUT)returnRecord;
    }

    public OUT readRecord(OUT reuse, byte[] bytes, int offset, int numBytes) throws IOException {
        if (this.lineDelimiterIsLinebreak && numBytes > 0 && bytes[offset + numBytes - 1] == 13) {
            --numBytes;
        }
        if (this.commentPrefix != null && this.commentPrefix.length <= numBytes) {
            boolean isComment = true;
            for (int i = 0; i < this.commentPrefix.length; ++i) {
                if (this.commentPrefix[i] == bytes[offset + i]) continue;
                isComment = false;
                break;
            }
            if (isComment) {
                ++this.commentCount;
                return null;
            }
        }
        if (this.parseRecord(this.parsedValues, bytes, offset, numBytes)) {
            return this.fillRecord(reuse, this.parsedValues);
        }
        ++this.invalidLineCount;
        return null;
    }

    protected abstract OUT fillRecord(OUT var1, Object[] var2);

    public Class<?>[] getFieldTypes() {
        return super.getGenericFieldTypes();
    }

    protected static boolean[] createDefaultMask(int size) {
        boolean[] includedMask = new boolean[size];
        for (int x = 0; x < includedMask.length; ++x) {
            includedMask[x] = true;
        }
        return includedMask;
    }

    protected static boolean[] toBooleanMask(int[] sourceFieldIndices) {
        Preconditions.checkNotNull((Object)sourceFieldIndices);
        int max = 0;
        for (int i : sourceFieldIndices) {
            if (i < 0) {
                throw new IllegalArgumentException("Field indices must not be smaller than zero.");
            }
            max = Math.max(i, max);
        }
        boolean[] includedMask = new boolean[max + 1];
        for (int i = 0; i < sourceFieldIndices.length; ++i) {
            includedMask[sourceFieldIndices[i]] = true;
        }
        return includedMask;
    }

    public String toString() {
        return "CSV Input (" + StringUtils.showControlCharacters((String)String.valueOf(this.getFieldDelimiter())) + ") " + this.getFilePath();
    }
}

