/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.Arrays;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.aggregators.AggregatorRegistry;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DeltaIterationResultSet;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

@Public
public class DeltaIteration<ST, WT> {
    private final AggregatorRegistry aggregators = new AggregatorRegistry();
    private final DataSet<ST> initialSolutionSet;
    private final DataSet<WT> initialWorkset;
    private final SolutionSetPlaceHolder<ST> solutionSetPlaceholder;
    private final WorksetPlaceHolder<WT> worksetPlaceholder;
    private final Keys<ST> keys;
    private final int maxIterations;
    private String name;
    private int parallelism = -1;
    private boolean solutionSetUnManaged;

    public DeltaIteration(ExecutionEnvironment context, TypeInformation<ST> type, DataSet<ST> solutionSet, DataSet<WT> workset, Keys<ST> keys, int maxIterations) {
        this.initialSolutionSet = solutionSet;
        this.initialWorkset = workset;
        this.solutionSetPlaceholder = new SolutionSetPlaceHolder(context, solutionSet.getType(), this);
        this.worksetPlaceholder = new WorksetPlaceHolder(context, workset.getType());
        this.keys = keys;
        this.maxIterations = maxIterations;
    }

    public DataSet<ST> closeWith(DataSet<ST> solutionSetDelta, DataSet<WT> newWorkset) {
        return new DeltaIterationResultSet<ST, WT>(this.initialSolutionSet.getExecutionEnvironment(), this.initialSolutionSet.getType(), this.initialWorkset.getType(), this, solutionSetDelta, newWorkset, this.keys, this.maxIterations);
    }

    public DataSet<ST> getInitialSolutionSet() {
        return this.initialSolutionSet;
    }

    public DataSet<WT> getInitialWorkset() {
        return this.initialWorkset;
    }

    public SolutionSetPlaceHolder<ST> getSolutionSet() {
        return this.solutionSetPlaceholder;
    }

    public WorksetPlaceHolder<WT> getWorkset() {
        return this.worksetPlaceholder;
    }

    public DeltaIteration<ST, WT> name(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DeltaIteration<ST, WT> parallelism(int parallelism) {
        Preconditions.checkArgument(parallelism > 0 || parallelism == -1, "The parallelism must be positive, or -1 (use default).");
        this.parallelism = parallelism;
        return this;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    @PublicEvolving
    public DeltaIteration<ST, WT> registerAggregator(String name, Aggregator<?> aggregator) {
        this.aggregators.registerAggregator(name, aggregator);
        return this;
    }

    @PublicEvolving
    public AggregatorRegistry getAggregators() {
        return this.aggregators;
    }

    public void setSolutionSetUnManaged(boolean solutionSetUnManaged) {
        this.solutionSetUnManaged = solutionSetUnManaged;
    }

    public boolean isSolutionSetUnManaged() {
        return this.solutionSetUnManaged;
    }

    @Public
    public static class WorksetPlaceHolder<WT>
    extends DataSet<WT> {
        private WorksetPlaceHolder(ExecutionEnvironment context, TypeInformation<WT> type) {
            super(context, type);
        }
    }

    @Public
    public static class SolutionSetPlaceHolder<ST>
    extends DataSet<ST> {
        private final DeltaIteration<ST, ?> deltaIteration;

        private SolutionSetPlaceHolder(ExecutionEnvironment context, TypeInformation<ST> type, DeltaIteration<ST, ?> deltaIteration) {
            super(context, type);
            this.deltaIteration = deltaIteration;
        }

        public void checkJoinKeyFields(int[] keyFields) {
            int[] ssKeys = ((DeltaIteration)this.deltaIteration).keys.computeLogicalKeyPositions();
            if (!Arrays.equals(ssKeys, keyFields)) {
                throw new InvalidProgramException("The solution can only be joined/co-grouped with the same keys as the elements are identified with (here: " + Arrays.toString(ssKeys) + ").");
            }
        }
    }
}

