/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.sampling;

import java.util.Iterator;
import java.util.Random;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.sampling.RandomSampler;
import org.apache.flink.api.java.sampling.SampledIterator;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.util.XORShiftRandom;

@Internal
public class BernoulliSampler<T>
extends RandomSampler<T> {
    private final double fraction;
    private final Random random;
    private static final double THRESHOLD = 0.33;

    public BernoulliSampler(double fraction) {
        this(fraction, (Random)new XORShiftRandom());
    }

    public BernoulliSampler(double fraction, long seed) {
        this(fraction, (Random)new XORShiftRandom(seed));
    }

    public BernoulliSampler(double fraction, Random random) {
        Preconditions.checkArgument(fraction >= 0.0 && fraction <= 1.0, "fraction fraction must between [0, 1].");
        this.fraction = fraction;
        this.random = random;
    }

    @Override
    public Iterator<T> sample(final Iterator<T> input) {
        if (this.fraction == 0.0) {
            return this.EMPTY_ITERABLE;
        }
        return new SampledIterator<T>(){
            T current = null;

            @Override
            public boolean hasNext() {
                if (this.current == null) {
                    this.current = this.getNextSampledElement();
                }
                return this.current != null;
            }

            @Override
            public T next() {
                if (this.current == null) {
                    return this.getNextSampledElement();
                }
                Object result = this.current;
                this.current = null;
                return result;
            }

            private T getNextSampledElement() {
                if (BernoulliSampler.this.fraction <= 0.33) {
                    double rand = BernoulliSampler.this.random.nextDouble();
                    double u = Math.max(rand, 1.0E-5);
                    int gap = (int)(Math.log(u) / Math.log(1.0 - BernoulliSampler.this.fraction));
                    if (input.hasNext()) {
                        int elementCount;
                        Object element = input.next();
                        for (elementCount = 0; input.hasNext() && elementCount < gap; ++elementCount) {
                            element = input.next();
                        }
                        if (elementCount < gap) {
                            return null;
                        }
                        return element;
                    }
                    return null;
                }
                while (input.hasNext()) {
                    Object element = input.next();
                    if (!(BernoulliSampler.this.random.nextDouble() <= BernoulliSampler.this.fraction)) continue;
                    return element;
                }
                return null;
            }
        };
    }
}

