/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.EnumComparator;
import org.apache.flink.api.common.typeutils.base.EnumSerializer;

public class EnumTypeInfo<T extends Enum<T>>
extends TypeInformation<T>
implements AtomicType<T> {
    private static final long serialVersionUID = 8936740290137178660L;
    private final Class<T> typeClass;

    public EnumTypeInfo(Class<T> typeClass) {
        if (typeClass == null) {
            throw new NullPointerException();
        }
        if (!Enum.class.isAssignableFrom(typeClass)) {
            throw new IllegalArgumentException("EnumTypeInfo can only be used for subclasses of " + Enum.class.getName());
        }
        this.typeClass = typeClass;
    }

    public TypeComparator<T> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        return new EnumComparator(sortOrderAscending);
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    public boolean isKeyType() {
        return true;
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig executionConfig) {
        return new EnumSerializer(this.typeClass);
    }

    public String toString() {
        return "EnumTypeInfo<" + this.typeClass.getName() + ">";
    }

    public int hashCode() {
        return this.typeClass.hashCode() ^ 0xD3A2646C;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EnumTypeInfo) {
            return this.typeClass == ((EnumTypeInfo)((Object)obj)).typeClass;
        }
        return false;
    }
}

