/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import de.javakaffee.kryoserializers.jodatime.JodaDateTimeSerializer;
import de.javakaffee.kryoserializers.jodatime.JodaIntervalSerializer;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class Serializers {
    private static Set<Class<?>> alreadySeen = new HashSet();

    public static void recursivelyRegisterType(Class<?> type, ExecutionConfig config) {
        Field[] fields;
        alreadySeen.add(type);
        if (type.isPrimitive()) {
            return;
        }
        config.registerKryoType(type);
        Serializers.addSerializerForType(config, type);
        for (Field field : fields = type.getDeclaredFields()) {
            Class<?> clazz;
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            Type fieldType = field.getGenericType();
            if (fieldType instanceof ParameterizedType) {
                ParameterizedType parameterizedFieldType = (ParameterizedType)fieldType;
                for (Type t : parameterizedFieldType.getActualTypeArguments()) {
                    Class<?> clazz2;
                    if (!TypeExtractor.isClassType(t) || alreadySeen.contains(clazz2 = TypeExtractor.typeToClass(t))) continue;
                    Serializers.recursivelyRegisterType(TypeExtractor.typeToClass(t), config);
                }
            }
            if (alreadySeen.contains(clazz = field.getType())) continue;
            Serializers.recursivelyRegisterType(clazz, config);
        }
    }

    public static void addSerializerForType(ExecutionConfig reg, Class<?> type) {
        if (GenericData.Record.class.isAssignableFrom(type)) {
            Serializers.registerGenericAvro(reg);
        }
        if (SpecificRecordBase.class.isAssignableFrom(type)) {
            Serializers.registerSpecificAvro(reg, type);
        }
        if (DateTime.class.isAssignableFrom(type) || Interval.class.isAssignableFrom(type)) {
            Serializers.registerJodaTime(reg);
        }
    }

    public static void registerGenericAvro(ExecutionConfig reg) {
        reg.registerTypeWithKryoSerializer(GenericData.Array.class, SpecificInstanceCollectionSerializerForArrayList.class);
        reg.addDefaultKryoSerializer(Schema.class, AvroSchemaSerializer.class);
    }

    public static void registerSpecificAvro(ExecutionConfig reg, Class<? extends SpecificRecordBase> avroType) {
        Serializers.registerGenericAvro(reg);
    }

    public static void registerJodaTime(ExecutionConfig reg) {
        reg.registerTypeWithKryoSerializer(DateTime.class, JodaDateTimeSerializer.class);
        reg.registerTypeWithKryoSerializer(Interval.class, JodaIntervalSerializer.class);
    }

    public static void registerJavaUtils(ExecutionConfig reg) {
    }

    public static class AvroSchemaSerializer
    extends Serializer<Schema>
    implements Serializable {
        public void write(Kryo kryo, Output output, Schema object) {
            String schemaAsString = object.toString(false);
            output.writeString(schemaAsString);
        }

        public Schema read(Kryo kryo, Input input, Class<Schema> type) {
            String schemaAsString = input.readString();
            Schema.Parser sParser = new Schema.Parser();
            return sParser.parse(schemaAsString);
        }
    }

    public static class SpecificInstanceCollectionSerializer<T extends Collection>
    extends CollectionSerializer
    implements Serializable {
        private Class<T> type;

        public SpecificInstanceCollectionSerializer(Class<T> type) {
            this.type = type;
        }

        protected Collection create(Kryo kryo, Input input, Class<Collection> type) {
            return (Collection)kryo.newInstance(this.type);
        }

        protected Collection createCopy(Kryo kryo, Collection original) {
            return (Collection)kryo.newInstance(this.type);
        }
    }

    public static class SpecificInstanceCollectionSerializerForArrayList
    extends SpecificInstanceCollectionSerializer<ArrayList> {
        public SpecificInstanceCollectionSerializerForArrayList() {
            super(ArrayList.class);
        }
    }
}

