/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.LocatableInputSplitAssigner;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.api.java.hadoop.common.HadoopInputFormatCommonBase;
import org.apache.flink.api.java.hadoop.mapreduce.utils.HadoopUtils;
import org.apache.flink.api.java.hadoop.mapreduce.wrapper.HadoopInputSplit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.core.io.LocatableInputSplit;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HadoopInputFormatBase<K, V, T>
extends HadoopInputFormatCommonBase<T, HadoopInputSplit> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HadoopInputFormatBase.class);
    private InputFormat<K, V> mapreduceInputFormat;
    protected Class<K> keyClass;
    protected Class<V> valueClass;
    private org.apache.hadoop.conf.Configuration configuration;
    protected transient RecordReader<K, V> recordReader;
    protected boolean fetched = false;
    protected boolean hasNext;

    public HadoopInputFormatBase(InputFormat<K, V> mapreduceInputFormat, Class<K> key, Class<V> value, Job job) {
        super(Preconditions.checkNotNull(job, "Job can not be null").getCredentials());
        this.mapreduceInputFormat = Preconditions.checkNotNull(mapreduceInputFormat);
        this.keyClass = Preconditions.checkNotNull(key);
        this.valueClass = Preconditions.checkNotNull(value);
        this.configuration = job.getConfiguration();
        HadoopUtils.mergeHadoopConf(this.configuration);
    }

    public org.apache.hadoop.conf.Configuration getConfiguration() {
        return this.configuration;
    }

    public void configure(Configuration parameters) {
        if (this.mapreduceInputFormat instanceof Configurable) {
            ((Configurable)this.mapreduceInputFormat).setConf(this.configuration);
        }
    }

    public BaseStatistics getStatistics(BaseStatistics cachedStats) throws IOException {
        block7: {
            JobContext jobContext;
            if (!(this.mapreduceInputFormat instanceof FileInputFormat)) {
                return null;
            }
            try {
                jobContext = HadoopUtils.instantiateJobContext(this.configuration, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            FileInputFormat.FileBaseStatistics cachedFileStats = cachedStats != null && cachedStats instanceof FileInputFormat.FileBaseStatistics ? (FileInputFormat.FileBaseStatistics)cachedStats : null;
            try {
                org.apache.hadoop.fs.Path[] paths = FileInputFormat.getInputPaths((JobContext)jobContext);
                return this.getFileStats(cachedFileStats, paths, new ArrayList<FileStatus>(1));
            }
            catch (IOException ioex) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Could not determine statistics due to an io error: " + ioex.getMessage());
                }
            }
            catch (Throwable t) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error("Unexpected problem while getting the file statistics: " + t.getMessage(), t);
            }
        }
        return null;
    }

    public HadoopInputSplit[] createInputSplits(int minNumSplits) throws IOException {
        List splits;
        JobContext jobContext;
        this.configuration.setInt("mapreduce.input.fileinputformat.split.minsize", minNumSplits);
        try {
            jobContext = HadoopUtils.instantiateJobContext(this.configuration, new JobID());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        jobContext.getCredentials().addAll(this.credentials);
        Credentials currentUserCreds = HadoopInputFormatBase.getCredentialsFromUGI(UserGroupInformation.getCurrentUser());
        if (currentUserCreds != null) {
            jobContext.getCredentials().addAll(currentUserCreds);
        }
        try {
            splits = this.mapreduceInputFormat.getSplits(jobContext);
        }
        catch (InterruptedException e) {
            throw new IOException("Could not get Splits.", e);
        }
        HadoopInputSplit[] hadoopInputSplits = new HadoopInputSplit[splits.size()];
        for (int i = 0; i < hadoopInputSplits.length; ++i) {
            hadoopInputSplits[i] = new HadoopInputSplit(i, (InputSplit)splits.get(i), jobContext);
        }
        return hadoopInputSplits;
    }

    public InputSplitAssigner getInputSplitAssigner(HadoopInputSplit[] inputSplits) {
        return new LocatableInputSplitAssigner((LocatableInputSplit[])inputSplits);
    }

    public void open(HadoopInputSplit split) throws IOException {
        TaskAttemptContext context;
        try {
            context = HadoopUtils.instantiateTaskAttemptContext(this.configuration, new TaskAttemptID());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.recordReader = this.mapreduceInputFormat.createRecordReader(split.getHadoopInputSplit(), context);
            this.recordReader.initialize(split.getHadoopInputSplit(), context);
        }
        catch (InterruptedException e) {
            throw new IOException("Could not create RecordReader.", e);
        }
        finally {
            this.fetched = false;
        }
    }

    public boolean reachedEnd() throws IOException {
        if (!this.fetched) {
            this.fetchNext();
        }
        return !this.hasNext;
    }

    protected void fetchNext() throws IOException {
        try {
            this.hasNext = this.recordReader.nextKeyValue();
        }
        catch (InterruptedException e) {
            throw new IOException("Could not fetch next KeyValue pair.", e);
        }
        finally {
            this.fetched = true;
        }
    }

    public void close() throws IOException {
        this.recordReader.close();
    }

    private FileInputFormat.FileBaseStatistics getFileStats(FileInputFormat.FileBaseStatistics cachedStats, org.apache.hadoop.fs.Path[] hadoopFilePaths, ArrayList<FileStatus> files) throws IOException {
        long latestModTime = 0L;
        for (org.apache.hadoop.fs.Path hadoopPath : hadoopFilePaths) {
            Path filePath = new Path(hadoopPath.toUri());
            FileSystem fs = FileSystem.get((URI)filePath.toUri());
            FileStatus file = fs.getFileStatus(filePath);
            latestModTime = Math.max(latestModTime, file.getModificationTime());
            if (file.isDir()) {
                FileStatus[] fss = fs.listStatus(filePath);
                files.ensureCapacity(files.size() + fss.length);
                for (FileStatus s : fss) {
                    if (s.isDir()) continue;
                    files.add(s);
                    latestModTime = Math.max(s.getModificationTime(), latestModTime);
                }
                continue;
            }
            files.add(file);
        }
        if (cachedStats != null && latestModTime <= cachedStats.getLastModificationTime()) {
            return cachedStats;
        }
        long len = 0L;
        for (FileStatus s : files) {
            len += s.getLen();
        }
        if (len <= 0L) {
            len = -1L;
        }
        return new FileInputFormat.FileBaseStatistics(latestModTime, len, -1.0f);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        super.write(out);
        out.writeUTF(this.mapreduceInputFormat.getClass().getName());
        out.writeUTF(this.keyClass.getName());
        out.writeUTF(this.valueClass.getName());
        this.configuration.write((DataOutput)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.read(in);
        String hadoopInputFormatClassName = in.readUTF();
        String keyClassName = in.readUTF();
        String valueClassName = in.readUTF();
        org.apache.hadoop.conf.Configuration configuration = new org.apache.hadoop.conf.Configuration();
        configuration.readFields((DataInput)in);
        if (this.configuration == null) {
            this.configuration = configuration;
        }
        try {
            this.mapreduceInputFormat = (InputFormat)Class.forName(hadoopInputFormatClassName, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate the hadoop input format", e);
        }
        try {
            this.keyClass = Class.forName(keyClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find key class.", e);
        }
        try {
            this.valueClass = Class.forName(valueClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find value class.", e);
        }
    }
}

