/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.Arrays;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.java.typeutils.runtime.TupleComparator;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;

public final class TupleTypeInfo<T extends Tuple>
extends TupleTypeInfoBase<T> {
    private static final long serialVersionUID = 1L;
    protected final String[] fieldNames;
    private TypeComparator<?>[] fieldComparators;
    private int[] logicalKeyFields;
    private int comparatorHelperIndex = 0;

    public TupleTypeInfo(TypeInformation<?> ... types) {
        this(Tuple.getTupleClass(types.length), types);
    }

    public TupleTypeInfo(Class<T> tupleType, TypeInformation<?> ... types) {
        super(tupleType, types);
        if (types == null || types.length == 0 || types.length > 25) {
            throw new IllegalArgumentException();
        }
        this.fieldNames = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.fieldNames[i] = "f" + i;
        }
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public int getFieldIndex(String fieldName) {
        int fieldIndex = Integer.parseInt(fieldName.substring(1));
        if (fieldIndex >= this.getArity()) {
            return -1;
        }
        return fieldIndex;
    }

    public TupleSerializer<T> createSerializer(ExecutionConfig executionConfig) {
        TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
        for (int i = 0; i < this.types.length; ++i) {
            fieldSerializers[i] = this.types[i].createSerializer(executionConfig);
        }
        Class tupleClass = this.getTypeClass();
        return new TupleSerializer(tupleClass, fieldSerializers);
    }

    protected void initializeNewComparator(int localKeyCount) {
        this.fieldComparators = new TypeComparator[localKeyCount];
        this.logicalKeyFields = new int[localKeyCount];
        this.comparatorHelperIndex = 0;
    }

    protected void addCompareField(int fieldId, TypeComparator<?> comparator) {
        this.fieldComparators[this.comparatorHelperIndex] = comparator;
        this.logicalKeyFields[this.comparatorHelperIndex] = fieldId;
        ++this.comparatorHelperIndex;
    }

    protected TypeComparator<T> getNewComparator(ExecutionConfig executionConfig) {
        TypeComparator<?>[] finalFieldComparators = Arrays.copyOf(this.fieldComparators, this.comparatorHelperIndex);
        int[] finalLogicalKeyFields = Arrays.copyOf(this.logicalKeyFields, this.comparatorHelperIndex);
        int maxKey = 0;
        for (int key : finalLogicalKeyFields) {
            maxKey = Math.max(maxKey, key);
        }
        TypeSerializer[] fieldSerializers = new TypeSerializer[maxKey + 1];
        for (int i = 0; i <= maxKey; ++i) {
            fieldSerializers[i] = this.types[i].createSerializer(executionConfig);
        }
        if (finalFieldComparators.length == 0 || finalLogicalKeyFields.length == 0 || fieldSerializers.length == 0 || finalFieldComparators.length != finalLogicalKeyFields.length) {
            throw new IllegalArgumentException("Tuple comparator creation has a bug");
        }
        return new TupleComparator(finalLogicalKeyFields, finalFieldComparators, fieldSerializers);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TupleTypeInfo) {
            TupleTypeInfo other = (TupleTypeInfo)((Object)obj);
            return (this.tupleType == null && other.tupleType == null || this.tupleType.equals(other.tupleType)) && Arrays.deepEquals(this.types, other.types);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.types.hashCode() ^ Arrays.deepHashCode(this.types);
    }

    @Override
    public String toString() {
        return "Java " + super.toString();
    }

    public static <X extends Tuple> TupleTypeInfo<X> getBasicTupleTypeInfo(Class<?> ... basicTypes) {
        if (basicTypes == null || basicTypes.length == 0) {
            throw new IllegalArgumentException();
        }
        TypeInformation[] infos = new TypeInformation[basicTypes.length];
        for (int i = 0; i < infos.length; ++i) {
            Class<?> type = basicTypes[i];
            if (type == null) {
                throw new IllegalArgumentException("Type at position " + i + " is null.");
            }
            BasicTypeInfo info = BasicTypeInfo.getInfoFor(type);
            if (info == null) {
                throw new IllegalArgumentException("Type at position " + i + " is not a basic type.");
            }
            infos[i] = info;
        }
        TupleTypeInfo tupleInfo = new TupleTypeInfo(infos);
        return tupleInfo;
    }
}

