/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.flink.api.common.typeinfo.TypeInformation;

public class PojoField
implements Serializable {
    public transient Field field;
    public TypeInformation<?> type;

    public PojoField(Field field, TypeInformation<?> type) {
        this.field = field;
        this.type = type;
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.defaultWriteObject();
        out.writeObject(this.field.getDeclaringClass());
        out.writeUTF(this.field.getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String fieldName = in.readUTF();
        this.field = null;
        for (Class clazz = (Class)in.readObject(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                this.field = clazz.getDeclaredField(fieldName);
                this.field.setAccessible(true);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        if (this.field == null) {
            throw new RuntimeException("Class resolved at TaskManager is not compatible with class read during Plan setup. (" + fieldName + ")");
        }
    }

    public String toString() {
        return "PojoField " + this.field.getDeclaringClass() + "." + this.field.getName() + " (" + this.type + ")";
    }
}

