/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.operators.Grouping;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.operators.SortedGrouping;
import org.apache.flink.api.java.operators.translation.KeyExtractingMapper;
import org.apache.flink.api.java.operators.translation.PlanUnwrappingReduceGroupOperator;
import org.apache.flink.api.java.operators.translation.PlanUnwrappingSortedReduceGroupOperator;
import org.apache.flink.api.java.operators.translation.TwoKeyExtractingMapper;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;

public class GroupReduceOperator<IN, OUT>
extends SingleInputUdfOperator<IN, OUT, GroupReduceOperator<IN, OUT>> {
    private final GroupReduceFunction<IN, OUT> function;
    private final Grouping<IN> grouper;
    private final String defaultName;
    private boolean combinable;

    public GroupReduceOperator(DataSet<IN> input, TypeInformation<OUT> resultType, GroupReduceFunction<IN, OUT> function, String defaultName) {
        super(input, resultType);
        this.function = function;
        this.grouper = null;
        this.defaultName = defaultName;
        this.checkCombinability();
    }

    public GroupReduceOperator(Grouping<IN> input, TypeInformation<OUT> resultType, GroupReduceFunction<IN, OUT> function, String defaultName) {
        super(input != null ? input.getDataSet() : null, resultType);
        this.function = function;
        this.grouper = input;
        this.defaultName = defaultName;
        this.checkCombinability();
    }

    private void checkCombinability() {
        if (this.function instanceof GroupCombineFunction && this.function.getClass().getAnnotation(RichGroupReduceFunction.Combinable.class) != null) {
            this.combinable = true;
        }
    }

    protected GroupReduceFunction<IN, OUT> getFunction() {
        return this.function;
    }

    public boolean isCombinable() {
        return this.combinable;
    }

    public GroupReduceOperator<IN, OUT> setCombinable(boolean combinable) {
        if (combinable && !(this.function instanceof GroupCombineFunction)) {
            throw new IllegalArgumentException("The function does not implement the combine interface.");
        }
        this.combinable = combinable;
        return this;
    }

    @Override
    public SingleInputSemanticProperties getSemanticProperties() {
        SingleInputSemanticProperties props = super.getSemanticProperties();
        if (props != null && this.grouper != null && this.grouper.keys instanceof Keys.SelectorFunctionKeys) {
            int offset = ((Keys.SelectorFunctionKeys)this.grouper.keys).getKeyType().getTotalFields();
            if (this.grouper instanceof SortedGrouping) {
                offset += ((SortedGrouping)this.grouper).getSortSelectionFunctionKey().getKeyType().getTotalFields();
            }
            props = SemanticPropUtil.addSourceFieldOffset(props, this.getInputType().getTotalFields(), offset);
        }
        return props;
    }

    protected GroupReduceOperatorBase<?, OUT, ?> translateToDataFlow(Operator<IN> input) {
        String name;
        String string = name = this.getName() != null ? this.getName() : "GroupReduce at " + this.defaultName;
        if (this.grouper == null) {
            UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getInputType(), this.getResultType());
            GroupReduceOperatorBase po = new GroupReduceOperatorBase(this.function, operatorInfo, new int[0], name);
            po.setCombinable(this.combinable);
            po.setInput(input);
            po.setParallelism(1);
            return po;
        }
        if (this.grouper.getKeys() instanceof Keys.SelectorFunctionKeys) {
            Keys.SelectorFunctionKeys selectorKeys = (Keys.SelectorFunctionKeys)this.grouper.getKeys();
            if (this.grouper instanceof SortedGrouping) {
                SortedGrouping sortedGrouper = (SortedGrouping)this.grouper;
                Keys.SelectorFunctionKeys sortKeys = sortedGrouper.getSortSelectionFunctionKey();
                PlanUnwrappingSortedReduceGroupOperator po = GroupReduceOperator.translateSelectorFunctionSortedReducer(selectorKeys, sortKeys, this.function, this.getInputType(), this.getResultType(), name, input, this.isCombinable());
                int[] sortKeyPositions = sortedGrouper.getGroupSortKeyPositions();
                Order[] sortOrders = sortedGrouper.getGroupSortOrders();
                Ordering o = new Ordering();
                for (int i = 0; i < sortKeyPositions.length; ++i) {
                    o.appendOrdering(Integer.valueOf(sortKeyPositions[i]), null, sortOrders[i]);
                }
                po.setGroupOrder(o);
                po.setParallelism(this.getParallelism());
                po.setCustomPartitioner(this.grouper.getCustomPartitioner());
                return po;
            }
            PlanUnwrappingReduceGroupOperator po = GroupReduceOperator.translateSelectorFunctionReducer(selectorKeys, this.function, this.getInputType(), this.getResultType(), name, input, this.isCombinable());
            po.setParallelism(this.getParallelism());
            po.setCustomPartitioner(this.grouper.getCustomPartitioner());
            return po;
        }
        if (this.grouper.getKeys() instanceof Keys.ExpressionKeys) {
            int[] logicalKeyPositions = this.grouper.getKeys().computeLogicalKeyPositions();
            UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getInputType(), this.getResultType());
            GroupReduceOperatorBase po = new GroupReduceOperatorBase(this.function, operatorInfo, logicalKeyPositions, name);
            po.setCombinable(this.combinable);
            po.setInput(input);
            po.setParallelism(this.getParallelism());
            po.setCustomPartitioner(this.grouper.getCustomPartitioner());
            if (this.grouper instanceof SortedGrouping) {
                SortedGrouping sortedGrouper = (SortedGrouping)this.grouper;
                int[] sortKeyPositions = sortedGrouper.getGroupSortKeyPositions();
                Order[] sortOrders = sortedGrouper.getGroupSortOrders();
                Ordering o = new Ordering();
                for (int i = 0; i < sortKeyPositions.length; ++i) {
                    o.appendOrdering(Integer.valueOf(sortKeyPositions[i]), null, sortOrders[i]);
                }
                po.setGroupOrder(o);
            }
            return po;
        }
        throw new UnsupportedOperationException("Unrecognized key type.");
    }

    private static <IN, OUT, K> PlanUnwrappingReduceGroupOperator<IN, OUT, K> translateSelectorFunctionReducer(Keys.SelectorFunctionKeys<IN, ?> rawKeys, GroupReduceFunction<IN, OUT> function, TypeInformation<IN> inputType, TypeInformation<OUT> outputType, String name, Operator<IN> input, boolean combinable) {
        Keys.SelectorFunctionKeys<IN, ?> keys = rawKeys;
        TupleTypeInfo typeInfoWithKey = new TupleTypeInfo(keys.getKeyType(), inputType);
        KeyExtractingMapper extractor = new KeyExtractingMapper(keys.getKeyExtractor());
        PlanUnwrappingReduceGroupOperator reducer = new PlanUnwrappingReduceGroupOperator(function, keys, name, outputType, typeInfoWithKey, combinable);
        MapOperatorBase mapper = new MapOperatorBase(extractor, new UnaryOperatorInformation(inputType, typeInfoWithKey), "Key Extractor");
        reducer.setInput((Operator)mapper);
        mapper.setInput(input);
        mapper.setParallelism(input.getParallelism());
        return reducer;
    }

    private static <IN, OUT, K1, K2> PlanUnwrappingSortedReduceGroupOperator<IN, OUT, K1, K2> translateSelectorFunctionSortedReducer(Keys.SelectorFunctionKeys<IN, ?> rawGroupingKey, Keys.SelectorFunctionKeys<IN, ?> rawSortingKey, GroupReduceFunction<IN, OUT> function, TypeInformation<IN> inputType, TypeInformation<OUT> outputType, String name, Operator<IN> input, boolean combinable) {
        Keys.SelectorFunctionKeys<IN, ?> groupingKey = rawGroupingKey;
        Keys.SelectorFunctionKeys<IN, ?> sortingKey = rawSortingKey;
        TupleTypeInfo typeInfoWithKey = new TupleTypeInfo(groupingKey.getKeyType(), sortingKey.getKeyType(), inputType);
        TwoKeyExtractingMapper extractor = new TwoKeyExtractingMapper(groupingKey.getKeyExtractor(), sortingKey.getKeyExtractor());
        PlanUnwrappingSortedReduceGroupOperator reducer = new PlanUnwrappingSortedReduceGroupOperator(function, groupingKey, sortingKey, name, outputType, typeInfoWithKey, combinable);
        MapOperatorBase mapper = new MapOperatorBase(extractor, new UnaryOperatorInformation(inputType, typeInfoWithKey), "Key Extractor");
        reducer.setInput((Operator)mapper);
        mapper.setInput(input);
        mapper.setParallelism(input.getParallelism());
        return reducer;
    }
}

