/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;

public class SemanticPropUtil {
    private static final String REGEX_WILDCARD = "[\\*\\_]";
    private static final String REGEX_SINGLE_FIELD = "[\\p{L}\\p{Digit}_\\$]+";
    private static final String REGEX_NESTED_FIELDS = "(([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?";
    private static final String REGEX_LIST = "(((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?;)*((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?);?)";
    private static final String REGEX_FORWARD = "(((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|[\\*\\_])->((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|[\\*\\_]))";
    private static final String REGEX_FIELD_OR_FORWARD = "((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|(((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|[\\*\\_])->((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|[\\*\\_])))";
    private static final String REGEX_ANNOTATION = "((((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|(((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|[\\*\\_])->((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|[\\*\\_])));)*(((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|(((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|[\\*\\_])->((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|[\\*\\_]))));?)";
    private static final Pattern PATTERN_WILDCARD = Pattern.compile("[\\*\\_]");
    private static final Pattern PATTERN_FORWARD = Pattern.compile("(((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|[\\*\\_])->((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|[\\*\\_]))");
    private static final Pattern PATTERN_ANNOTATION = Pattern.compile("((((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|(((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|[\\*\\_])->((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|[\\*\\_])));)*(((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|(((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|[\\*\\_])->((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?|[\\*\\_]))));?)");
    private static final Pattern PATTERN_LIST = Pattern.compile("(((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?;)*((([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?);?)");
    private static final Pattern PATTERN_FIELD = Pattern.compile("(([\\p{L}\\p{Digit}_\\$]+\\.)*[\\p{L}\\p{Digit}_\\$]+)(\\.[\\*\\_])?");

    public static SingleInputSemanticProperties createProjectionPropertiesSingle(int[] fields, CompositeType<?> inType) {
        Character.isJavaIdentifierStart(1);
        SingleInputSemanticProperties ssp = new SingleInputSemanticProperties();
        int[] sourceOffsets = new int[inType.getArity()];
        sourceOffsets[0] = 0;
        for (int i = 1; i < inType.getArity(); ++i) {
            sourceOffsets[i] = inType.getTypeAt(i - 1).getTotalFields() + sourceOffsets[i - 1];
        }
        int targetOffset = 0;
        for (int i = 0; i < fields.length; ++i) {
            int sourceOffset = sourceOffsets[fields[i]];
            int numFieldsToCopy = inType.getTypeAt(fields[i]).getTotalFields();
            for (int j = 0; j < numFieldsToCopy; ++j) {
                ssp.addForwardedField(sourceOffset + j, targetOffset + j);
            }
            targetOffset += numFieldsToCopy;
        }
        return ssp;
    }

    public static DualInputSemanticProperties createProjectionPropertiesDual(int[] fields, boolean[] isFromFirst, TypeInformation<?> inType1, TypeInformation<?> inType2) {
        int[] sourceOffsets2;
        int[] sourceOffsets1;
        DualInputSemanticProperties dsp = new DualInputSemanticProperties();
        if (inType1 instanceof TupleTypeInfo) {
            sourceOffsets1 = new int[inType1.getArity()];
            sourceOffsets1[0] = 0;
            for (int i = 1; i < inType1.getArity(); ++i) {
                sourceOffsets1[i] = ((TupleTypeInfo)inType1).getTypeAt(i - 1).getTotalFields() + sourceOffsets1[i - 1];
            }
        } else {
            sourceOffsets1 = new int[]{0};
        }
        if (inType2 instanceof TupleTypeInfo) {
            sourceOffsets2 = new int[inType2.getArity()];
            sourceOffsets2[0] = 0;
            for (int i = 1; i < inType2.getArity(); ++i) {
                sourceOffsets2[i] = ((TupleTypeInfo)inType2).getTypeAt(i - 1).getTotalFields() + sourceOffsets2[i - 1];
            }
        } else {
            sourceOffsets2 = new int[]{0};
        }
        int targetOffset = 0;
        for (int i = 0; i < fields.length; ++i) {
            int numFieldsToCopy;
            int sourceOffset;
            int input;
            if (isFromFirst[i]) {
                input = 0;
                if (fields[i] == -1) {
                    sourceOffset = 0;
                    numFieldsToCopy = inType1.getTotalFields();
                } else {
                    sourceOffset = sourceOffsets1[fields[i]];
                    numFieldsToCopy = ((TupleTypeInfo)inType1).getTypeAt(fields[i]).getTotalFields();
                }
            } else {
                input = 1;
                if (fields[i] == -1) {
                    sourceOffset = 0;
                    numFieldsToCopy = inType2.getTotalFields();
                } else {
                    sourceOffset = sourceOffsets2[fields[i]];
                    numFieldsToCopy = ((TupleTypeInfo)inType2).getTypeAt(fields[i]).getTotalFields();
                }
            }
            for (int j = 0; j < numFieldsToCopy; ++j) {
                dsp.addForwardedField(input, sourceOffset + j, targetOffset + j);
            }
            targetOffset += numFieldsToCopy;
        }
        return dsp;
    }

    public static SingleInputSemanticProperties addSourceFieldOffset(SingleInputSemanticProperties props, int numInputFields, int offset) {
        SingleInputSemanticProperties offsetProps = new SingleInputSemanticProperties();
        if (props.getReadFields(0) != null) {
            FieldSet offsetReadFields = new FieldSet();
            Iterator iterator = props.getReadFields(0).iterator();
            while (iterator.hasNext()) {
                int r = (Integer)iterator.next();
                offsetReadFields = offsetReadFields.addField(Integer.valueOf(r + offset));
            }
            offsetProps.addReadFields(offsetReadFields);
        }
        for (int s = 0; s < numInputFields; ++s) {
            FieldSet targetFields = props.getForwardingTargetFields(0, s);
            Iterator iterator = targetFields.iterator();
            while (iterator.hasNext()) {
                int t = (Integer)iterator.next();
                offsetProps.addForwardedField(s + offset, t);
            }
        }
        return offsetProps;
    }

    public static DualInputSemanticProperties addSourceFieldOffsets(DualInputSemanticProperties props, int numInputFields1, int numInputFields2, int offset1, int offset2) {
        int t;
        FieldSet targetFields;
        int s;
        int r;
        Iterator iterator;
        FieldSet offsetReadFields;
        DualInputSemanticProperties offsetProps = new DualInputSemanticProperties();
        if (props.getReadFields(0) != null) {
            offsetReadFields = new FieldSet();
            iterator = props.getReadFields(0).iterator();
            while (iterator.hasNext()) {
                r = (Integer)iterator.next();
                offsetReadFields = offsetReadFields.addField(Integer.valueOf(r + offset1));
            }
            offsetProps.addReadFields(0, offsetReadFields);
        }
        if (props.getReadFields(1) != null) {
            offsetReadFields = new FieldSet();
            iterator = props.getReadFields(1).iterator();
            while (iterator.hasNext()) {
                r = (Integer)iterator.next();
                offsetReadFields = offsetReadFields.addField(Integer.valueOf(r + offset2));
            }
            offsetProps.addReadFields(1, offsetReadFields);
        }
        for (s = 0; s < numInputFields1; ++s) {
            targetFields = props.getForwardingTargetFields(0, s);
            Iterator iterator2 = targetFields.iterator();
            while (iterator2.hasNext()) {
                t = (Integer)iterator2.next();
                offsetProps.addForwardedField(0, s + offset1, t);
            }
        }
        for (s = 0; s < numInputFields2; ++s) {
            targetFields = props.getForwardingTargetFields(1, s);
            Iterator iterator3 = targetFields.iterator();
            while (iterator3.hasNext()) {
                t = (Integer)iterator3.next();
                offsetProps.addForwardedField(1, s + offset2, t);
            }
        }
        return offsetProps;
    }

    public static SingleInputSemanticProperties getSemanticPropsSingle(Set<Annotation> set, TypeInformation<?> inType, TypeInformation<?> outType) {
        if (set == null) {
            return new SingleInputSemanticProperties();
        }
        Iterator<Annotation> it = set.iterator();
        String[] forwarded = null;
        String[] nonForwarded = null;
        String[] read = null;
        while (it.hasNext()) {
            Annotation ann = it.next();
            if (ann instanceof FunctionAnnotation.ForwardedFields) {
                forwarded = ((FunctionAnnotation.ForwardedFields)ann).value();
                continue;
            }
            if (ann instanceof FunctionAnnotation.NonForwardedFields) {
                nonForwarded = ((FunctionAnnotation.NonForwardedFields)ann).value();
                continue;
            }
            if (ann instanceof FunctionAnnotation.ReadFields) {
                read = ((FunctionAnnotation.ReadFields)ann).value();
                continue;
            }
            if (!(ann instanceof FunctionAnnotation.ForwardedFieldsFirst) && !(ann instanceof FunctionAnnotation.ForwardedFieldsSecond) && !(ann instanceof FunctionAnnotation.NonForwardedFieldsFirst) && !(ann instanceof FunctionAnnotation.NonForwardedFieldsSecond) && !(ann instanceof FunctionAnnotation.ReadFieldsFirst) && !(ann instanceof FunctionAnnotation.ReadFieldsSecond)) continue;
            throw new SemanticProperties.InvalidSemanticAnnotationException("Annotation " + ann.getClass() + " invalid for single input function.");
        }
        if (forwarded != null || nonForwarded != null || read != null) {
            SingleInputSemanticProperties result = new SingleInputSemanticProperties();
            SemanticPropUtil.getSemanticPropsSingleFromString(result, forwarded, nonForwarded, read, inType, outType);
            return result;
        }
        return new SingleInputSemanticProperties();
    }

    public static DualInputSemanticProperties getSemanticPropsDual(Set<Annotation> set, TypeInformation<?> inType1, TypeInformation<?> inType2, TypeInformation<?> outType) {
        if (set == null) {
            return new DualInputSemanticProperties();
        }
        Iterator<Annotation> it = set.iterator();
        String[] forwardedFirst = null;
        String[] forwardedSecond = null;
        String[] nonForwardedFirst = null;
        String[] nonForwardedSecond = null;
        String[] readFirst = null;
        String[] readSecond = null;
        while (it.hasNext()) {
            Annotation ann = it.next();
            if (ann instanceof FunctionAnnotation.ForwardedFieldsFirst) {
                forwardedFirst = ((FunctionAnnotation.ForwardedFieldsFirst)ann).value();
                continue;
            }
            if (ann instanceof FunctionAnnotation.ForwardedFieldsSecond) {
                forwardedSecond = ((FunctionAnnotation.ForwardedFieldsSecond)ann).value();
                continue;
            }
            if (ann instanceof FunctionAnnotation.NonForwardedFieldsFirst) {
                nonForwardedFirst = ((FunctionAnnotation.NonForwardedFieldsFirst)ann).value();
                continue;
            }
            if (ann instanceof FunctionAnnotation.NonForwardedFieldsSecond) {
                nonForwardedSecond = ((FunctionAnnotation.NonForwardedFieldsSecond)ann).value();
                continue;
            }
            if (ann instanceof FunctionAnnotation.ReadFieldsFirst) {
                readFirst = ((FunctionAnnotation.ReadFieldsFirst)ann).value();
                continue;
            }
            if (ann instanceof FunctionAnnotation.ReadFieldsSecond) {
                readSecond = ((FunctionAnnotation.ReadFieldsSecond)ann).value();
                continue;
            }
            if (!(ann instanceof FunctionAnnotation.ForwardedFields) && !(ann instanceof FunctionAnnotation.NonForwardedFields) && !(ann instanceof FunctionAnnotation.ReadFields)) continue;
            throw new SemanticProperties.InvalidSemanticAnnotationException("Annotation " + ann.getClass() + " invalid for dual input function.");
        }
        if (forwardedFirst != null || nonForwardedFirst != null || readFirst != null || forwardedSecond != null || nonForwardedSecond != null || readSecond != null) {
            DualInputSemanticProperties result = new DualInputSemanticProperties();
            SemanticPropUtil.getSemanticPropsDualFromString(result, forwardedFirst, forwardedSecond, nonForwardedFirst, nonForwardedSecond, readFirst, readSecond, inType1, inType2, outType);
            return result;
        }
        return new DualInputSemanticProperties();
    }

    public static void getSemanticPropsSingleFromString(SingleInputSemanticProperties result, String[] forwarded, String[] nonForwarded, String[] readSet, TypeInformation<?> inType, TypeInformation<?> outType) {
        boolean hasForwardedAnnotation = false;
        boolean hasNonForwardedAnnotation = false;
        if (forwarded != null && forwarded.length > 0) {
            hasForwardedAnnotation = true;
        }
        if (nonForwarded != null && nonForwarded.length > 0) {
            hasNonForwardedAnnotation = true;
        }
        if (hasForwardedAnnotation && hasNonForwardedAnnotation) {
            throw new SemanticProperties.InvalidSemanticAnnotationException("Either ForwardedFields OR NonForwardedFields annotation permitted, NOT both.");
        }
        if (hasForwardedAnnotation) {
            SemanticPropUtil.parseForwardedFields((SemanticProperties)result, forwarded, inType, outType, 0);
        } else if (hasNonForwardedAnnotation) {
            SemanticPropUtil.parseNonForwardedFields((SemanticProperties)result, nonForwarded, inType, outType, 0);
        }
        SemanticPropUtil.parseReadFields((SemanticProperties)result, readSet, inType, 0);
    }

    public static void getSemanticPropsDualFromString(DualInputSemanticProperties result, String[] forwardedFirst, String[] forwardedSecond, String[] nonForwardedFirst, String[] nonForwardedSecond, String[] readFieldsFirst, String[] readFieldsSecond, TypeInformation<?> inType1, TypeInformation<?> inType2, TypeInformation<?> outType) {
        boolean hasForwardedFirstAnnotation = false;
        boolean hasForwardedSecondAnnotation = false;
        boolean hasNonForwardedFirstAnnotation = false;
        boolean hasNonForwardedSecondAnnotation = false;
        if (forwardedFirst != null && forwardedFirst.length > 0) {
            hasForwardedFirstAnnotation = true;
        }
        if (forwardedSecond != null && forwardedSecond.length > 0) {
            hasForwardedSecondAnnotation = true;
        }
        if (nonForwardedFirst != null && nonForwardedFirst.length > 0) {
            hasNonForwardedFirstAnnotation = true;
        }
        if (nonForwardedSecond != null && nonForwardedSecond.length > 0) {
            hasNonForwardedSecondAnnotation = true;
        }
        if (hasForwardedFirstAnnotation && hasNonForwardedFirstAnnotation) {
            throw new SemanticProperties.InvalidSemanticAnnotationException("Either ForwardedFieldsFirst OR NonForwardedFieldsFirst annotation permitted, NOT both.");
        }
        if (hasForwardedSecondAnnotation && hasNonForwardedSecondAnnotation) {
            throw new SemanticProperties.InvalidSemanticAnnotationException("Either ForwardedFieldsSecond OR NonForwardedFieldsSecond annotation permitted, NOT both.");
        }
        if (hasForwardedFirstAnnotation) {
            SemanticPropUtil.parseForwardedFields((SemanticProperties)result, forwardedFirst, inType1, outType, 0);
        } else if (hasNonForwardedFirstAnnotation) {
            SemanticPropUtil.parseNonForwardedFields((SemanticProperties)result, nonForwardedFirst, inType1, outType, 0);
        }
        if (hasForwardedSecondAnnotation) {
            SemanticPropUtil.parseForwardedFields((SemanticProperties)result, forwardedSecond, inType2, outType, 1);
        } else if (hasNonForwardedSecondAnnotation) {
            SemanticPropUtil.parseNonForwardedFields((SemanticProperties)result, nonForwardedSecond, inType2, outType, 1);
        }
        SemanticPropUtil.parseReadFields((SemanticProperties)result, readFieldsFirst, inType1, 0);
        SemanticPropUtil.parseReadFields((SemanticProperties)result, readFieldsSecond, inType2, 1);
    }

    private static void parseForwardedFields(SemanticProperties sp, String[] forwardedStr, TypeInformation<?> inType, TypeInformation<?> outType, int input) {
        if (forwardedStr == null) {
            return;
        }
        for (String s : forwardedStr) {
            if (s == null) continue;
            Matcher wcMatcher = PATTERN_WILDCARD.matcher(s = s.replaceAll("\\s", ""));
            if (wcMatcher.matches()) {
                if (!inType.equals(outType)) {
                    throw new SemanticProperties.InvalidSemanticAnnotationException("Forwarded field annotation \"" + s + "\" with wildcard only allowed for identical input and output types.");
                }
                for (int i = 0; i < inType.getTotalFields(); ++i) {
                    if (sp instanceof SingleInputSemanticProperties) {
                        ((SingleInputSemanticProperties)sp).addForwardedField(i, i);
                        continue;
                    }
                    if (!(sp instanceof DualInputSemanticProperties)) continue;
                    ((DualInputSemanticProperties)sp).addForwardedField(input, i, i);
                }
                return;
            }
            Matcher matcher = PATTERN_ANNOTATION.matcher(s);
            if (!matcher.matches()) {
                throw new SemanticProperties.InvalidSemanticAnnotationException("Invalid format of forwarded field annotation \"" + s + "\".");
            }
            Matcher forwardMatcher = PATTERN_FORWARD.matcher(s);
            while (forwardMatcher.find()) {
                String sourceStr = forwardMatcher.group(2);
                String targetStr = forwardMatcher.group(6);
                try {
                    int targetField;
                    int sourceField;
                    int i;
                    if (!SemanticPropUtil.areFieldsCompatible(sourceStr, inType, targetStr, outType)) {
                        throw new SemanticProperties.InvalidSemanticAnnotationException("Referenced fields of forwarded field annotation \"" + s + "\" do not match.");
                    }
                    List<CompositeType.FlatFieldDescriptor> inFFDs = SemanticPropUtil.getFlatFields(sourceStr, inType);
                    List<CompositeType.FlatFieldDescriptor> outFFDs = SemanticPropUtil.getFlatFields(targetStr, outType);
                    if (sp instanceof SingleInputSemanticProperties) {
                        for (i = 0; i < inFFDs.size(); ++i) {
                            sourceField = inFFDs.get(i).getPosition();
                            targetField = outFFDs.get(i).getPosition();
                            ((SingleInputSemanticProperties)sp).addForwardedField(sourceField, targetField);
                        }
                        continue;
                    }
                    if (!(sp instanceof DualInputSemanticProperties)) continue;
                    for (i = 0; i < inFFDs.size(); ++i) {
                        sourceField = inFFDs.get(i).getPosition();
                        targetField = outFFDs.get(i).getPosition();
                        ((DualInputSemanticProperties)sp).addForwardedField(input, sourceField, targetField);
                    }
                }
                catch (CompositeType.InvalidFieldReferenceException ifre) {
                    throw new SemanticProperties.InvalidSemanticAnnotationException("Invalid field reference in forwarded field annotation \"" + sourceStr + "->" + targetStr + "\".", (Throwable)ifre);
                }
                catch (SemanticProperties.InvalidSemanticAnnotationException isae) {
                    throw new SemanticProperties.InvalidSemanticAnnotationException("Forwarded field annotation \"" + sourceStr + "->" + targetStr + "\" could not be added.", (Throwable)isae);
                }
            }
            s = forwardMatcher.replaceAll("");
            Matcher listMatcher = PATTERN_LIST.matcher(s);
            while (listMatcher.find()) {
                String list = listMatcher.group();
                Matcher fieldMatcher = PATTERN_FIELD.matcher(list);
                while (fieldMatcher.find()) {
                    String fieldStr = fieldMatcher.group();
                    try {
                        if (!SemanticPropUtil.areFieldsCompatible(fieldStr, inType, fieldStr, outType)) {
                            throw new SemanticProperties.InvalidSemanticAnnotationException("Referenced fields of forwarded field annotation \"" + s + "\" do not match.");
                        }
                        List<CompositeType.FlatFieldDescriptor> inFFDs = SemanticPropUtil.getFlatFields(fieldStr, inType);
                        List<CompositeType.FlatFieldDescriptor> outFFDs = SemanticPropUtil.getFlatFields(fieldStr, outType);
                        for (int i = 0; i < inFFDs.size(); ++i) {
                            int sourcePos = inFFDs.get(i).getPosition();
                            int targetPos = outFFDs.get(i).getPosition();
                            if (sp instanceof SingleInputSemanticProperties) {
                                ((SingleInputSemanticProperties)sp).addForwardedField(sourcePos, targetPos);
                                continue;
                            }
                            if (!(sp instanceof DualInputSemanticProperties)) continue;
                            ((DualInputSemanticProperties)sp).addForwardedField(input, sourcePos, targetPos);
                        }
                    }
                    catch (CompositeType.InvalidFieldReferenceException ifre) {
                        throw new SemanticProperties.InvalidSemanticAnnotationException("Invalid field reference in forwarded field annotation \"" + fieldStr + "\".", (Throwable)ifre);
                    }
                    catch (SemanticProperties.InvalidSemanticAnnotationException isae) {
                        throw new SemanticProperties.InvalidSemanticAnnotationException("Forwarded field annotation \"" + fieldStr + "\" could not be added.", (Throwable)isae);
                    }
                }
            }
        }
    }

    private static void parseNonForwardedFields(SemanticProperties sp, String[] nonForwardedStr, TypeInformation<?> inType, TypeInformation<?> outType, int input) {
        if (nonForwardedStr == null) {
            return;
        }
        FieldSet excludedFields = new FieldSet();
        for (String s : nonForwardedStr) {
            if ((s = s.replaceAll("\\s", "")).equals("")) continue;
            if (!inType.equals(outType)) {
                throw new SemanticProperties.InvalidSemanticAnnotationException("Non-forwarded fields annotation only allowed for identical input and output types.");
            }
            Matcher matcher = PATTERN_LIST.matcher(s);
            if (!matcher.matches()) {
                throw new SemanticProperties.InvalidSemanticAnnotationException("Invalid format of non-forwarded fields annotation \"" + s + "\".");
            }
            matcher = PATTERN_FIELD.matcher(s);
            while (matcher.find()) {
                String fieldStr = matcher.group();
                try {
                    List<CompositeType.FlatFieldDescriptor> inFFDs = SemanticPropUtil.getFlatFields(fieldStr, inType);
                    for (CompositeType.FlatFieldDescriptor ffd : inFFDs) {
                        excludedFields = excludedFields.addField(Integer.valueOf(ffd.getPosition()));
                    }
                }
                catch (CompositeType.InvalidFieldReferenceException ifre) {
                    throw new SemanticProperties.InvalidSemanticAnnotationException("Invalid field reference in non-forwarded fields annotation \"" + fieldStr + "\".", (Throwable)ifre);
                }
            }
        }
        for (int i = 0; i < inType.getTotalFields(); ++i) {
            if (excludedFields.contains(Integer.valueOf(i))) continue;
            if (sp instanceof SingleInputSemanticProperties) {
                ((SingleInputSemanticProperties)sp).addForwardedField(i, i);
                continue;
            }
            if (!(sp instanceof DualInputSemanticProperties)) continue;
            ((DualInputSemanticProperties)sp).addForwardedField(input, i, i);
        }
    }

    private static void parseReadFields(SemanticProperties sp, String[] readFieldStrings, TypeInformation<?> inType, int input) {
        if (readFieldStrings == null) {
            return;
        }
        for (String s : readFieldStrings) {
            FieldSet readFields = new FieldSet();
            Matcher wcMatcher = PATTERN_WILDCARD.matcher(s = s.replaceAll("\\s", ""));
            if (wcMatcher.matches()) {
                for (int i = 0; i < inType.getTotalFields(); ++i) {
                    readFields = readFields.addField(Integer.valueOf(i));
                }
            } else {
                Matcher matcher = PATTERN_LIST.matcher(s);
                if (!matcher.matches()) {
                    throw new SemanticProperties.InvalidSemanticAnnotationException("Invalid format of read field annotation \"" + s + "\".");
                }
                matcher = PATTERN_FIELD.matcher(s);
                while (matcher.find()) {
                    String fieldStr = matcher.group();
                    try {
                        List<CompositeType.FlatFieldDescriptor> ffds = SemanticPropUtil.getFlatFields(fieldStr, inType);
                        for (CompositeType.FlatFieldDescriptor ffd : ffds) {
                            readFields = readFields.addField(Integer.valueOf(ffd.getPosition()));
                        }
                    }
                    catch (CompositeType.InvalidFieldReferenceException ifre) {
                        throw new SemanticProperties.InvalidSemanticAnnotationException("Invalid field reference in read field annotation \"" + fieldStr + "\".", (Throwable)ifre);
                    }
                }
            }
            if (sp instanceof SingleInputSemanticProperties) {
                ((SingleInputSemanticProperties)sp).addReadFields(readFields);
                continue;
            }
            if (!(sp instanceof DualInputSemanticProperties)) continue;
            ((DualInputSemanticProperties)sp).addReadFields(input, readFields);
        }
    }

    private static boolean areFieldsCompatible(String sourceField, TypeInformation<?> inType, String targetField, TypeInformation<?> outType) {
        TypeInformation<?> sourceType = SemanticPropUtil.getExpressionTypeInformation(sourceField, inType);
        TypeInformation<?> targetType = SemanticPropUtil.getExpressionTypeInformation(targetField, outType);
        return sourceType.equals(targetType);
    }

    private static TypeInformation<?> getExpressionTypeInformation(String fieldStr, TypeInformation<?> typeInfo) {
        Matcher wildcardMatcher = PATTERN_WILDCARD.matcher(fieldStr);
        if (wildcardMatcher.matches()) {
            return typeInfo;
        }
        Matcher expMatcher = PATTERN_FIELD.matcher(fieldStr);
        if (!expMatcher.matches()) {
            throw new CompositeType.InvalidFieldReferenceException("Invalid field expression \"" + fieldStr + "\".");
        }
        if (typeInfo instanceof CompositeType) {
            return ((CompositeType)typeInfo).getTypeAt(expMatcher.group(1));
        }
        throw new CompositeType.InvalidFieldReferenceException("Nested field expression \"" + fieldStr + "\" not possible on atomic type (" + typeInfo + ").");
    }

    private static List<CompositeType.FlatFieldDescriptor> getFlatFields(String fieldStr, TypeInformation<?> typeInfo) {
        if (typeInfo instanceof CompositeType) {
            return ((CompositeType)typeInfo).getFlatFields(fieldStr);
        }
        Matcher wildcardMatcher = PATTERN_WILDCARD.matcher(fieldStr);
        if (wildcardMatcher.matches()) {
            return Collections.singletonList(new CompositeType.FlatFieldDescriptor(0, typeInfo));
        }
        throw new CompositeType.InvalidFieldReferenceException("Nested field expression \"" + fieldStr + "\" not possible on atomic type (" + typeInfo + ").");
    }
}

