/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.PlanExecutor;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.configuration.Configuration;

public class LocalEnvironment
extends ExecutionEnvironment {
    private Configuration configuration;

    public LocalEnvironment() {
        if (!ExecutionEnvironment.localExecutionIsAllowed()) {
            throw new InvalidProgramException("The LocalEnvironment cannot be used when submitting a program through a client.");
        }
    }

    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        JavaPlan p = this.createProgramPlan(jobName);
        PlanExecutor executor = PlanExecutor.createLocalExecutor((Configuration)this.configuration);
        return executor.executePlan((Plan)p);
    }

    @Override
    public String getExecutionPlan() throws Exception {
        JavaPlan p = this.createProgramPlan(null, false);
        PlanExecutor executor = PlanExecutor.createLocalExecutor((Configuration)this.configuration);
        return executor.getOptimizerPlanAsJSON((Plan)p);
    }

    public String toString() {
        return "Local Environment (parallelism = " + (this.getParallelism() == -1 ? "default" : Integer.valueOf(this.getParallelism())) + ") : " + this.getIdString();
    }

    public void setConfiguration(Configuration customConfiguration) {
        this.configuration = customConfiguration;
    }
}

