/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.CopyableValueComparator;
import org.apache.flink.api.java.typeutils.runtime.CopyableValueSerializer;
import org.apache.flink.api.java.typeutils.runtime.ValueComparator;
import org.apache.flink.api.java.typeutils.runtime.ValueSerializer;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.Value;

public class ValueTypeInfo<T extends Value>
extends TypeInformation<T>
implements AtomicType<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type;

    public ValueTypeInfo(Class<T> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (!Value.class.isAssignableFrom(type) && !type.equals(Value.class)) {
            throw new IllegalArgumentException("ValueTypeInfo can only be used for subclasses of " + Value.class.getName());
        }
        this.type = type;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<T> getTypeClass() {
        return this.type;
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public boolean isKeyType() {
        return Comparable.class.isAssignableFrom(this.type);
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig executionConfig) {
        if (CopyableValue.class.isAssignableFrom(this.type)) {
            return ValueTypeInfo.createCopyableValueSerializer(this.type.asSubclass(CopyableValue.class));
        }
        return new ValueSerializer<T>(this.type);
    }

    public TypeComparator<T> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        if (!this.isKeyType()) {
            throw new RuntimeException("The type " + this.type.getName() + " is not Comparable.");
        }
        if (CopyableValue.class.isAssignableFrom(this.type)) {
            return new CopyableValueComparator<T>(sortOrderAscending, this.type);
        }
        return new ValueComparator<T>(sortOrderAscending, this.type);
    }

    private static <X extends CopyableValue<X>> CopyableValueSerializer<X> createCopyableValueSerializer(Class<X> clazz) {
        return new CopyableValueSerializer<X>(clazz);
    }

    public int hashCode() {
        return this.type.hashCode() ^ 0xD3A2646C;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == ValueTypeInfo.class) {
            return this.type == ((ValueTypeInfo)((Object)obj)).type;
        }
        return false;
    }

    public String toString() {
        return "ValueType<" + this.type.getSimpleName() + ">";
    }

    static final <X extends Value> TypeInformation<X> getValueTypeInfo(Class<X> typeClass) {
        if (Value.class.isAssignableFrom(typeClass) && !typeClass.equals(Value.class)) {
            return new ValueTypeInfo<X>(typeClass);
        }
        throw new InvalidTypesException("The given class is no subclass of " + Value.class.getName());
    }
}

