/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;

public abstract class TupleTypeInfoBase<T>
extends CompositeType<T> {
    private static final long serialVersionUID = 1L;
    private static final String REGEX_FIELD = "(f?)([0-9]+)";
    private static final String REGEX_NESTED_FIELDS = "((f?)([0-9]+))(\\.(.+))?";
    private static final String REGEX_NESTED_FIELDS_WILDCARD = "((f?)([0-9]+))(\\.(.+))?|\\*|\\_";
    private static final Pattern PATTERN_FIELD = Pattern.compile("(f?)([0-9]+)");
    private static final Pattern PATTERN_NESTED_FIELDS = Pattern.compile("((f?)([0-9]+))(\\.(.+))?");
    private static final Pattern PATTERN_NESTED_FIELDS_WILDCARD = Pattern.compile("((f?)([0-9]+))(\\.(.+))?|\\*|\\_");
    protected final TypeInformation<?>[] types;
    protected final Class<T> tupleType;
    private int totalFields;

    public TupleTypeInfoBase(Class<T> tupleType, TypeInformation<?> ... types) {
        super(tupleType);
        this.tupleType = tupleType;
        this.types = types;
        for (TypeInformation<?> type : types) {
            this.totalFields += type.getTotalFields();
        }
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return true;
    }

    public int getArity() {
        return this.types.length;
    }

    public int getTotalFields() {
        return this.totalFields;
    }

    public Class<T> getTypeClass() {
        return this.tupleType;
    }

    public void addAllFields(int startKeyId, List<CompositeType.FlatFieldDescriptor> keyFields) {
        for (int i = 0; i < this.getArity(); ++i) {
            TypeInformation<?> type = this.types[i];
            if (type instanceof AtomicType) {
                keyFields.add(new CompositeType.FlatFieldDescriptor(startKeyId, type));
            } else if (type instanceof TupleTypeInfoBase) {
                TupleTypeInfoBase ttb = (TupleTypeInfoBase)type;
                ttb.addAllFields(startKeyId, keyFields);
            }
            startKeyId += type.getTotalFields();
        }
    }

    public void getFlatFields(String fieldExpression, int offset, List<CompositeType.FlatFieldDescriptor> result) {
        Matcher matcher = PATTERN_NESTED_FIELDS_WILDCARD.matcher(fieldExpression);
        if (!matcher.matches()) {
            throw new CompositeType.InvalidFieldReferenceException("Invalid tuple field reference \"" + fieldExpression + "\".");
        }
        String field = matcher.group(0);
        if (field.equals("*") || field.equals("_")) {
            int keyPosition = 0;
            for (TypeInformation<?> type : this.types) {
                if (type instanceof CompositeType) {
                    CompositeType cType = (CompositeType)type;
                    cType.getFlatFields(String.valueOf("*"), offset + keyPosition, result);
                    keyPosition += cType.getTotalFields() - 1;
                } else {
                    result.add(new CompositeType.FlatFieldDescriptor(offset + keyPosition, type));
                }
                ++keyPosition;
            }
            return;
        }
        String fieldStr = matcher.group(1);
        Matcher fieldMatcher = PATTERN_FIELD.matcher(fieldStr);
        if (!fieldMatcher.matches()) {
            throw new RuntimeException("Invalid matcher pattern");
        }
        field = fieldMatcher.group(2);
        int fieldPos = Integer.valueOf(field);
        if (fieldPos >= this.getArity()) {
            throw new CompositeType.InvalidFieldReferenceException("Tuple field expression \"" + fieldStr + "\" out of bounds of " + this.toString() + ".");
        }
        TypeInformation fieldType = this.getTypeAt(fieldPos);
        String tail = matcher.group(5);
        if (tail == null) {
            if (fieldType instanceof CompositeType) {
                for (int i = 0; i < fieldPos; ++i) {
                    offset += this.getTypeAt(i).getTotalFields();
                }
                ((CompositeType)fieldType).getFlatFields("*", offset, result);
                return;
            }
            int flatFieldPos = offset;
            for (int i = 0; i < fieldPos; ++i) {
                flatFieldPos += this.getTypeAt(i).getTotalFields();
            }
            result.add(new CompositeType.FlatFieldDescriptor(flatFieldPos, fieldType));
            return;
        }
        if (fieldType instanceof CompositeType) {
            for (int i = 0; i < fieldPos; ++i) {
                offset += this.getTypeAt(i).getTotalFields();
            }
            ((CompositeType)fieldType).getFlatFields(tail, offset, result);
            return;
        }
        throw new CompositeType.InvalidFieldReferenceException("Nested field expression \"" + tail + "\" not possible on atomic type " + fieldType + ".");
    }

    public <X> TypeInformation<X> getTypeAt(String fieldExpression) {
        Matcher matcher = PATTERN_NESTED_FIELDS.matcher(fieldExpression);
        if (!matcher.matches()) {
            if (fieldExpression.equals("*") || fieldExpression.equals("_")) {
                throw new CompositeType.InvalidFieldReferenceException("Wildcard expressions are not allowed here.");
            }
            throw new CompositeType.InvalidFieldReferenceException("Invalid format of tuple field expression \"" + fieldExpression + "\".");
        }
        String fieldStr = matcher.group(1);
        Matcher fieldMatcher = PATTERN_FIELD.matcher(fieldStr);
        if (!fieldMatcher.matches()) {
            throw new RuntimeException("Invalid matcher pattern");
        }
        String field = fieldMatcher.group(2);
        int fieldPos = Integer.valueOf(field);
        if (fieldPos >= this.getArity()) {
            throw new CompositeType.InvalidFieldReferenceException("Tuple field expression \"" + fieldStr + "\" out of bounds of " + this.toString() + ".");
        }
        TypeInformation<X> fieldType = this.getTypeAt(fieldPos);
        String tail = matcher.group(5);
        if (tail == null) {
            return fieldType;
        }
        if (fieldType instanceof CompositeType) {
            return ((CompositeType)fieldType).getTypeAt(tail);
        }
        throw new CompositeType.InvalidFieldReferenceException("Nested field expression \"" + tail + "\" not possible on atomic type " + fieldType + ".");
    }

    public <X> TypeInformation<X> getTypeAt(int pos) {
        if (pos < 0 || pos >= this.types.length) {
            throw new IndexOutOfBoundsException();
        }
        TypeInformation<?> typed = this.types[pos];
        return typed;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TupleTypeInfoBase) {
            TupleTypeInfoBase other = (TupleTypeInfoBase)((Object)obj);
            return (this.tupleType == null && other.tupleType == null || this.tupleType.equals(other.tupleType)) && Arrays.deepEquals(this.types, other.types);
        }
        return false;
    }

    public int hashCode() {
        return this.types.hashCode() ^ Arrays.deepHashCode(this.types);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder("Tuple");
        bld.append(this.types.length).append('<');
        bld.append(this.types[0]);
        for (int i = 1; i < this.types.length; ++i) {
            bld.append(", ").append(this.types[i]);
        }
        bld.append('>');
        return bld.toString();
    }

    public boolean hasDeterministicFieldOrder() {
        return true;
    }
}

