/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.google.protobuf.Message;
import com.twitter.chill.ScalaKryoInstantiator;
import com.twitter.chill.avro.AvroSerializer;
import com.twitter.chill.protobuf.ProtobufSerializer;
import com.twitter.chill.thrift.TBaseSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.util.Utf8;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.api.java.typeutils.runtime.NoFetchingInput;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.thrift.TBase;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public class KryoSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 2L;
    private final Class<T> type;
    private transient Kryo kryo;
    private transient T copyInstance;
    private transient DataOutputView previousOut;
    private transient DataInputView previousIn;
    private transient Input input;
    private transient Output output;

    public KryoSerializer(Class<T> type) {
        if (type == null) {
            throw new NullPointerException("Type class cannot be null.");
        }
        this.type = type;
    }

    public boolean isImmutableType() {
        return false;
    }

    public KryoSerializer<T> duplicate() {
        return new KryoSerializer<T>(this.type);
    }

    public T createInstance() {
        if (Modifier.isAbstract(this.type.getModifiers()) || Modifier.isInterface(this.type.getModifiers())) {
            return null;
        }
        this.checkKryoInitialized();
        try {
            return (T)this.kryo.newInstance(this.type);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public T copy(T from) {
        if (from == null) {
            return null;
        }
        this.checkKryoInitialized();
        try {
            return (T)this.kryo.copy(from);
        }
        catch (KryoException ke) {
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            Output output = new Output((OutputStream)baout);
            this.kryo.writeObject(output, from);
            output.close();
            ByteArrayInputStream bain = new ByteArrayInputStream(baout.toByteArray());
            Input input = new Input((InputStream)bain);
            return (T)this.kryo.readObject(input, from.getClass());
        }
    }

    public T copy(T from, T reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T record, DataOutputView target) throws IOException {
        this.checkKryoInitialized();
        if (target != this.previousOut) {
            DataOutputViewStream outputStream = new DataOutputViewStream(target);
            this.output = new Output((OutputStream)outputStream);
            this.previousOut = target;
        }
        try {
            this.kryo.writeClassAndObject(this.output, record);
            this.output.flush();
        }
        catch (KryoException ke) {
            Throwable cause = ke.getCause();
            if (cause instanceof EOFException) {
                throw (EOFException)cause;
            }
            throw ke;
        }
    }

    public T deserialize(DataInputView source) throws IOException {
        this.checkKryoInitialized();
        if (source != this.previousIn) {
            DataInputViewStream inputStream = new DataInputViewStream(source);
            this.input = new NoFetchingInput(inputStream);
            this.previousIn = source;
        }
        try {
            return (T)this.kryo.readClassAndObject(this.input);
        }
        catch (KryoException ke) {
            Throwable cause = ke.getCause();
            if (cause instanceof EOFException) {
                throw (EOFException)cause;
            }
            throw ke;
        }
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.checkKryoInitialized();
        if (this.copyInstance == null) {
            this.copyInstance = this.createInstance();
        }
        T tmp = this.deserialize(this.copyInstance, source);
        this.serialize(tmp, target);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof KryoSerializer) {
            KryoSerializer other = (KryoSerializer)((Object)obj);
            return other.type == this.type;
        }
        return false;
    }

    private void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = new ScalaKryoInstantiator().newKryo();
            this.kryo.addDefaultSerializer(Throwable.class, (Serializer)new JavaSerializer());
            this.kryo.addDefaultSerializer(Message.class, ProtobufSerializer.class);
            this.kryo.addDefaultSerializer(TBase.class, TBaseSerializer.class);
            if (SpecificRecordBase.class.isAssignableFrom(this.type)) {
                ClassTag tag = ClassTag$.MODULE$.apply(this.type);
                this.kryo.register(this.type, AvroSerializer.SpecificRecordSerializer((ClassTag)tag));
            }
            this.kryo.register(Utf8.class);
            this.kryo.register(GenericData.EnumSymbol.class);
            this.kryo.register(GenericData.Fixed.class);
            this.kryo.register(GenericData.StringType.class);
            this.kryo.register(GenericData.Array.class, new SpecificInstanceCollectionSerializer<ArrayList>(ArrayList.class));
            this.kryo.addDefaultSerializer(Schema.class, (Serializer)new AvroSchemaSerializer());
            this.kryo.register(this.type);
            this.kryo.setRegistrationRequired(false);
            this.kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
        }
    }

    Kryo getKryo() {
        this.checkKryoInitialized();
        return this.kryo;
    }

    public static class AvroSchemaSerializer
    extends Serializer<Schema> {
        public void write(Kryo kryo, Output output, Schema object) {
            String schemaAsString = object.toString(false);
            output.writeString(schemaAsString);
        }

        public Schema read(Kryo kryo, Input input, Class<Schema> type) {
            String schemaAsString = input.readString();
            Schema.Parser sParser = new Schema.Parser();
            return sParser.parse(schemaAsString);
        }
    }

    public static class SpecificInstanceCollectionSerializer<T extends Collection>
    extends CollectionSerializer {
        Class<T> type;

        public SpecificInstanceCollectionSerializer(Class<T> type) {
            this.type = type;
        }

        protected Collection create(Kryo kryo, Input input, Class<Collection> type) {
            return (Collection)kryo.newInstance(this.type);
        }

        protected Collection createCopy(Kryo kryo, Collection original) {
            return (Collection)kryo.newInstance(this.type);
        }
    }
}

