/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapreduce.wrapper;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.flink.core.io.LocatableInputSplit;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

public class HadoopInputSplit
extends LocatableInputSplit {
    public transient InputSplit mapreduceInputSplit;
    public transient JobContext jobContext;
    private int splitNumber;

    public InputSplit getHadoopInputSplit() {
        return this.mapreduceInputSplit;
    }

    public HadoopInputSplit() {
    }

    public HadoopInputSplit(int splitNumber, InputSplit mapreduceInputSplit, JobContext jobContext) {
        this.splitNumber = splitNumber;
        if (!(mapreduceInputSplit instanceof Writable)) {
            throw new IllegalArgumentException("InputSplit must implement Writable interface.");
        }
        this.mapreduceInputSplit = mapreduceInputSplit;
        this.jobContext = jobContext;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.splitNumber);
        out.writeUTF(this.mapreduceInputSplit.getClass().getName());
        Writable w = (Writable)this.mapreduceInputSplit;
        w.write((DataOutput)out);
    }

    public void read(DataInputView in) throws IOException {
        this.splitNumber = in.readInt();
        String className = in.readUTF();
        if (this.mapreduceInputSplit == null) {
            try {
                Class<Writable> inputSplit = Class.forName(className).asSubclass(Writable.class);
                this.mapreduceInputSplit = (InputSplit)WritableFactories.newInstance(inputSplit);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create InputSplit", e);
            }
        }
        ((Writable)this.mapreduceInputSplit).readFields((DataInput)in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.splitNumber);
        out.writeUTF(this.mapreduceInputSplit.getClass().getName());
        Writable w = (Writable)this.mapreduceInputSplit;
        w.write((DataOutput)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.splitNumber = in.readInt();
        String className = in.readUTF();
        if (this.mapreduceInputSplit == null) {
            try {
                Class<Writable> inputSplit = Class.forName(className).asSubclass(Writable.class);
                this.mapreduceInputSplit = (InputSplit)WritableFactories.newInstance(inputSplit);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create InputSplit", e);
            }
        }
        ((Writable)this.mapreduceInputSplit).readFields((DataInput)in);
    }

    public int getSplitNumber() {
        return this.splitNumber;
    }

    public String[] getHostnames() {
        try {
            return this.mapreduceInputSplit.getLocations();
        }
        catch (IOException e) {
            return new String[0];
        }
        catch (InterruptedException e) {
            return new String[0];
        }
    }
}

